local apolloengine = require "apolloengine"

local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local ReplayAllFrameAni = BlueNode:extend();

---- 游戏运行模式
function ReplayAllFrameAni:new(...)
  ReplayAllFrameAni.super.new(self,...);
end


function ReplayAllFrameAni:_OnUpdate(args)
  self:_RecursiveResetNode(args[1]);
end


function ReplayAllFrameAni:_RecursiveResetNode(rootNode)

  local FrameAniCom = rootNode:GetComponent(apolloengine.Node.CT_FRAME_PLAYER);
  if FrameAniCom then
    FrameAniCom:Reset();
    FrameAniCom:Play();
  end
  local childNode = rootNode:GetChildrens();
  for i=1,#childNode do
    local node = childNode[i];
    self:_RecursiveResetNode(node);
  end
end


---- 编辑器模式
ReplayAllFrameAni:RegisterInput(1, apolloengine.Node:RTTI(), "target", "递归遍历子节点，重新播放所有序列帧组件", BlueSelf());

ReplayAllFrameAni:RegisterExecInput(1, "exec", "Execute");

ReplayAllFrameAni:RegisterExecOutput(1, "exec", "Execute");

ReplayAllFrameAni:SetFunctionName("ReplayAllFrameAni");

return ReplayAllFrameAni ;

