
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"


local GetLocalScale = BlueNode:extend();

---- 游戏运行模式
function GetLocalScale:new(...)
  GetLocalScale.super.new(self, ...)
end

function GetLocalScale:_OnUpdate(args)
  local transformComponent_target = args[1];
  local result = transformComponent_target:GetLocalScale();
  return result:x(), result:y(), result:z();
end

---- 编辑器模式
GetLocalScale:RegisterOutput(1, Types.FloatType, "x", "x坐标");
GetLocalScale:RegisterOutput(2, Types.FloatType, "y", "y坐标");
GetLocalScale:RegisterOutput(3, Types.FloatType, "z", "z坐标");

GetLocalScale:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());

GetLocalScale:SetFunctionName("GetLocalScale");


return GetLocalScale ;

