local vc = require "libvenuscore"
local ae = require "apolloengine"
local mf = require "mathfunction"
local cv = require "computervisionfunction"


local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BlueUtility = require "bluecore.blueutility"

local FeedFaceParseRender = BlueNode:extend();

function FeedFaceParseRender:new(...)
  FeedFaceParseRender.super.new(self, ...)
end

local dtSize = cv.GPUSegmentComponent.mlRectSize
local dtPivot = cv.GPUSegmentComponent.mlRectPosition

function FeedFaceParseRender:_OnUpdate(args)
  local gpuSegComp = args[1]
  local renderComp = args[2]
  if renderComp == nil or gpuSegComp == nil then
    return
  end
  local tex = gpuSegComp:GetMask()
  local texSize = gpuSegComp:GetData(dtSize)[dtSize]
  local texPivot = gpuSegComp:GetData(dtPivot)[dtPivot]
  WARNING(string.format(
    "SUNTYLOG: FeedFaceParseRender: %s %s %s %s %s", 
    tostring(tex),
    tostring(texSize[1]), 
    tostring(texSize[2]), 
    tostring(texPivot[1]), 
    tostring(texPivot[2])
  ))
  renderComp:SetParameter("_MainTex", tex)
  renderComp:SetParameter("_MainSize", mf.vector2(texSize[1], texSize[2]))
  renderComp:SetParameter("_MainPivot", mf.vector2(texPivot[1], texPivot[2]))
end

  
FeedFaceParseRender:RegisterInput(1, cv.GPUSegmentComponent:RTTI(), "GPUComponent", "GPU人脸分割组件", BlueSelf());
FeedFaceParseRender:RegisterInput(2, ae.RenderComponent:RTTI(), "RenderComponent", "人脸分割渲染组件", BlueSelf());

FeedFaceParseRender:RegisterExecInput(1, "exec", "执行");

FeedFaceParseRender:RegisterExecOutput(1, "exec", "执行");

FeedFaceParseRender:SetFunctionName("FeedFaceParseRender");


return FeedFaceParseRender