local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetPostEffectValue = require "bluecore.base.get_posteffect_value"
local GetPostEffectBool = GetPostEffectValue:extend();

function GetPostEffectBool:new(...)
  GetPostEffectBool.super.new(self, ...)
end

function GetPostEffectBool:_IsRightType(value)
  return type(value) == "boolean";
end

GetPostEffectBool:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
GetPostEffectBool:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING);
GetPostEffectBool:RegisterOutput(1, Types.BoolType, "ParaValue", "参数值");
GetPostEffectBool:SetFunctionName("GetPostEffectBool");

return GetPostEffectBool;

