local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local BD = require "bluecore.bluedefined"
local venuscore = require "libvenuscore"
local BluePinInfo = require "bluecore.bluepininfo"

local LoopWithType = BlueNode:extend();

function LoopWithType:new(...)
  LoopWithType.super.new(self, ...);
end

function LoopWithType:_OnUpdate(args)
  local comp = args[1];
  local ani = args[2];
  local isLoop = args[3];
  comp:Loop(ani,isLoop);
  --args[1]:Loop(args[2]);
  
  --[[
    local comp = args[1] ;
  local ani = args[2] ;
  local type = args[3] ;
  comp:Play(ani, type);
  args[1]:Play();
  --]]
end

function LoopWithType:_GetCompOnPin1()

  if #self.inputs[1].links ~= 0 then

    local bluePinLink = self.inputs[1].links[1]
    local otherNode = self.graph:GetNode(bluePinLink.nodeUid);

    if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp == nil then
      self.compileResult = BD.EHINT.NOT_LINK_TO_COMP
      return nil
    end

    if venuscore.isNil(otherNode.comp) then
      self.compileResult = BD.EHINT.COMP_LOST
      return nil
    end

    return otherNode.comp

  else
    self.compileResult = BD.EHINT.PIN_1_EMPTY;
  end
  return nil
end

function LoopWithType:_IsCompPin(pin)
  return pin.pinType == BD.PIN_DATA_INPUT and pin.argId == 1
end

function LoopWithType:_SetupInstanceInfoTable()
  -- 不需要序列化 但需要单独修改一个引脚的infoTable
  -- override  infoTable
  local staticExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  local staticExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]
  local staticDataOutputsInfo = self.infoTable[BD.PIN_DATA_OUTPUT]
  local staticDataInputsInfo = self.infoTable[BD.PIN_DATA_INPUT]
  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = staticDataOutputsInfo
  self.infoTable[BD.PIN_EXEC_INPUT]  = staticExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = staticExecOutputsInfo


  self.myUnFixComboType = Types.ComboType:extend();
  self.myUnFixComboType:SetData({},{});

  local pinInfo = staticDataInputsInfo[1]
  self.infoTable[BD.PIN_DATA_INPUT][1] =  staticDataInputsInfo[1]
  pinInfo = staticDataInputsInfo[2]
  self.infoTable[BD.PIN_DATA_INPUT][2] = BluePinInfo(BD.PIN_DATA_INPUT, pinInfo.argId, self.myUnFixComboType, pinInfo.name,pinInfo.tips,pinInfo.default,pinInfo.delAble, pinInfo.groupName);
  pinInfo = staticDataInputsInfo[3]
  self.infoTable[BD.PIN_DATA_INPUT][3] =  staticDataInputsInfo[3]
end


function LoopWithType:_Reset()
  -- 引脚类型
  self.myUnFixComboType:SetData({},{});
  -- 字面值
  self.inputs[2].literal = ""
end

function LoopWithType:_OnDeserialize()
  LoopWithType.super._OnDeserialize(self);
  self:_SetupInstanceInfoTable();
end


function LoopWithType:_OnCompile()
  -- pin1 有连接 && 必须是引用component,
  self.compileResult = nil
  if LoopWithType.super._OnCompile(self) then
    local comp = self:_GetCompOnPin1();
    if comp then
      if comp:HasAnimation(self.inputs[2].literal) then
        return true
      else
        self.compileResult = BD.EHINT.ANI_NOT_EXIST;
      end
    end
  end
  return false
end

if _KRATOSEDITOR then

  function LoopWithType:_OnLink(selfPin, otherNode, otherPin)
    if self:_IsCompPin(selfPin) then
      local comp = self:_GetCompOnPin1();
      if comp then
        local animations = comp:GetAnimations();
        local anis = {}
        for ani, _ in pairs(animations) do
          table.insert(anis, ani)
        end
        self.myUnFixComboType:SetData(anis, anis);
      end

    end
  end

  function LoopWithType:_OnUnLink(unlinkPin)
    if self:_IsCompPin(unlinkPin) then
      self:_Reset();
    end
  end

  function LoopWithType:_OnCreateWithEditor()
    LoopWithType.super._OnCreateWithEditor(self);
    self:_SetupInstanceInfoTable();
  end

  function LoopWithType:_OnUpdateByEditor()
    LoopWithType.super._OnUpdateByEditor(self);
    self:_OnCompile();
  end

end

LoopWithType:RegisterInput(1, apolloengine.AnimationComponent:RTTI(), "target", "动画组件", BlueSelf());
LoopWithType:RegisterInput(2, Types.ComboType, "ani" , "动画曲线", BD.EMPTY_STRING); -- 不能是空串
LoopWithType:RegisterInput(3, Types.BoolType, "isLoop", "设置循环状态", true);

LoopWithType:RegisterExecInput(1, "exec", "Execute");

LoopWithType:RegisterExecOutput(1, "exec", "Execute");

LoopWithType:SetFunctionName("AniLoopWithType");

return LoopWithType;
