local cv = require "computervisionfunction"
--! do NOT import any other lua file here !
local BlueDefined = {}

-- blueprint's version
BlueDefined.VERSION = 1
BlueDefined.LEAK_DEBUG = false

-- 字符串常量
BlueDefined.THIS           = "SelfObj "
BlueDefined.BaseClass      = "BaseClass"
BlueDefined.SpecData       = "SpecData"
BlueDefined.LUA_CLASS_PATH = "luaPath"
BlueDefined.LuaPath = "comm:script/bluecore/blueprint.lua"
BlueDefined.ScenePath = "comm:script/bluecore/core/blue_scene.lua"
--BlueDefined.FuncPath = "comm:script/bluecore/bluefunction.lua"

BlueDefined.NilTexPath = "comm:documents/texture/material/defnormal.png"

-- node的类型
BlueDefined.EVENT_FUNCTION_NODE = 1	  -- 事件节点 这种节点会加入到 Event Graphic,并最终生成一个函数 给外部或者自己调用
BlueDefined.MEMBER_FUNCTION_NODE = 2
BlueDefined.STATIC_FUNCTION_NODE = 3  -- 静态方法/工具方法 包含所有数学方法 绘制时候可以用blueprint NodeType:Simple简单样式
BlueDefined.COMMENT_NODE = 4 				  -- 注释节点
BlueDefined.NO_EXEC_FUNCTION_NODE = 5 -- 没有执行引脚(输入/输出) 主要是绘制的时候颜色跟有执行引脚的不一样
BlueDefined.VARIABLE_NODE = 6				  -- 变量节点
BlueDefined.COMPONENT_NODE = 7 			  -- 组件(引用)节点
BlueDefined.REF_NODE = 8              -- 节点的引用
BlueDefined.USER_INTERFACE_NODE = 9   -- 交互节点 -- 弹窗选择文件 触发通知 发布海报
BlueDefined.COMPONENT_CONTENT_NODE = 10        -- 组件内容(引用)节点
BlueDefined.FUNCTION_INTERFACE_NODE = 11 --函数input output节点
--BlueDefined.FUNCTION_INS_NODE = 12    --函数实例
BlueDefined.FUNCTION_CALL_NODE= 13    -- 函数调用节点
BlueDefined.GLOBAL_CALL_NODE  = 14    -- 全局函数调用节点
BlueDefined.EVENT_CALL_NODE   = 15    -- 事件函数调用节点
BlueDefined.CUSTOM_EVENT_NODE = 16    -- 自定义事件节点
BlueDefined.EVENT_DISPATCH_NODE = 17  -- 事件分发器相关节点(绑定与解除绑定)
BlueDefined.DISPATCHER_CALL_NODE= 18  -- 事件分发器调用节点
BlueDefined.REF_BLUEPRINT = 19        -- blueprint的引用

-- 管脚的类型
BlueDefined.PIN_DATA_INPUT  = 1
BlueDefined.PIN_DATA_OUTPUT = 2
BlueDefined.PIN_EXEC_INPUT  = 3
BlueDefined.PIN_EXEC_OUTPUT = 4

BlueDefined.MORE_INPUT  = 1
BlueDefined.MORE_OUTPUT = 2
BlueDefined.MORE_EXEC_INPUT  = 3
BlueDefined.MORE_EXEC_OUTPUT = 4 --Sequence节点需要用到

-- 动态或者静态注册的引脚信息
BlueDefined.INPUTS_INFO = "inputsInfo"
BlueDefined.OUTPUTS_INFO = "outputsInfo"
BlueDefined.EXEC_INPUTS_INFO = "execInputsInfo"
BlueDefined.EXEC_OUTPUTS_INFO = "execOutputsInfo"

BlueDefined.OP_ADD = "add"
BlueDefined.OP_DEL = 'del'

BlueDefined.BLUE_MGR_INPUT = "mgr.in"
BlueDefined.BLUE_MGR_OUTPUT = "mgr.out"
BlueDefined.BLUE_MGR_DIR  = 'mgr.dir'

BlueDefined.LINK_UID = 1
BlueDefined.LINK_START = 2
BlueDefined.LINK_END = 3

BlueDefined.EHINT =
{
  PIN_1_EMPTY  = "pin 1 is empty",
  NOT_LINK_TO_COMP = "pin 1 is NOT linked to Reference node of Component",
  COMP_LOST = "Component is lost",
  ANI_NOT_EXIST = ".ani file not exist",
  NOT_ENABLE = "Component not enable AI feature",
  INS_NOT_EXIST = "script instance not exist",
  POSTEFFECT_NOT_EXIST = "post effect not exist",
  ERROR_PARA = "parameter error"
}

-- 序列化不保存空串 这里改成有一个空格的
BlueDefined.EMPTY_STRING = " "


BlueDefined.Catalog = {
  VAR = "variable",
  FUNC = "function",
  OTHER = "other"
}

BlueDefined.None = nil

BlueDefined.VarProp = {
  Name = 1 ,
  BaseType = 2 ,
  IsArray = 3,
}

BlueDefined.FuncInfoProp = {
  Name = 1 ,
  BaseType = 2 ,
  Value = 3,
}

BlueDefined.BluePrintExportFtnArray =
{
  --"AddVariable",            --增加变量(Deprecate)
  "CreateVariable",         --增加变量(无参 根据上一个变量的类型创建)
  "DeleteVariableByIndex",  --删除变量
  --"AddBluePrintNode",     --增加节点  luaPath可能是string或者clazz
  "CopyBluePrintNode",      --复制节点
  "AddNodePin",             --增加引脚
  "DeleteNodePin",          --删除引脚
  "DeleteBlueNode",         --删除节点
  "LinkPinToPin",           --连线
  "DeleteBlueLink",         --断开
  "DeleteAllBlueLink",      --删除所有连线
  "DeleteAllBlueNode",      --删除所有节点
  "SetInputPinLiteral",     --设置节点字面值
  "RefreshDependencyResource", --更新全局函数依赖资源
  --"CreateCompRefNode",    --创建Component引用节点 comp引用需要区分场景
  "AddDebugPoint",          --增加断点
  "DeleteDebugPoint",       --删除断点
  "SetCommentNodeContent",  --修改注释节点内容
  --"CompileCode"           -- editor scene 编译成功之后, game scene才会compile 分开处理
  -- SetModified            -- 标记蓝图已修改,在编辑器模型下,上述函数以及右侧反射面板的设置都会调用
  "AddLibEd",               -- 场景蓝图 创建函数库
  "DeleteLibEd",            -- 场景蓝图 删除函数库
  "CreateFunction",         -- 创建bluefunction(局部函数/全局函数(属于函数库))
  --"CreateFunctionInstance", -- 创建bluefunction的调用节点
  "DeleteFunctionByIndex",  -- 根据blueprint的funcIdx删除局部函数(TODO:全局？)
  "CreateCallFtnNode",       -- 调用函数节点(类之间)
  "SyncEd"                     -- 同步类信息到蓝图中(只有在打开蓝图的时候,类的信息才会同步到infoTable)
  ,"CreateFunctionForLibraryEd" -- 创建库函数
  ,"DeleteFunctionForLibraryEd" -- 删除库函数

  ,"CreateCustomEventNodeEd"      -- 创建事件节点
  ,"DeleteCustomEventNodeEd"      -- 删除事件节点
  ,"AddArgForCustomEventEd"     -- 事件节点输入参数增加
  ,"RemoveArgForCustomEventEd"  -- 事件节点输入参数删除

  ,"CreateEventDispatcherEd"    -- 创建事件分发器
  ,"DestroyEventDispatcherEd"   -- 删除事件分发器
  ,"RemoveArgForEventDispatcherEd" -- 事件分发器参数增加
  ,"AddArgForEventDispatcherEd"    -- 事件分发器参数删除

  ,"SetClassNameEd" -- 修改类名字
  ,"ChgLibNameEd"   -- 修改函数库名字

  ,"SyncDefaultValueByVarUidEd" -- 同步变量默认值
}

BlueDefined.RefVarName = "RefVarName"

BlueDefined.COMPONENT_CONTENT = 
{
  SCRIPT_INS = "script_ins_ref",
  CAMERA_POSTEFFECT = "post_effect_ref"
}

BlueDefined.EventType =
{
  Normal = 1,
  RegisterCallback = 2,
};

BlueDefined.Event =
{
  AnimationEvent =
  {
    Play = "OnAniPlay",
    Stop = "OnAniStop",
    End = "OnAniEnd",
    LoopEnd = "OnFrameAniLoopEnd",
    Trigger = "OnAniTrigger",
  };

  FrameAnimationEvent =
  {
    Play = "OnFrameAniPlay",
    Stop = "OnFrameAniStop",
    End = "OnFrameAniEnd",
    LoopEnd = "OnFrameAniLoopEnd"
  };

  CollisionEvent =
  {
    Enter        = "OnCollisionEnter",
    BeginOverlay = "BeginOverlay",
    EndOverlay   = "EndOverlay",
    KeepOverlay  = "KeepOverlay"
  };

  RecordComponent = "RecordComponent";
  RecordEvent =
  {
    Start = 1,
    Stop = 2,
  };

  PhotoUploadResponse = "PhotoUploadResponse"; --用户点击了相册照片上传到贴纸
  UserEventComponent= "UserEventComponent" ;
  TouchGlobalPath   = "TouchComponent"; -- 相当于全局的对象 在 eventdispatcher.RegisterCallback指定监听这个全局对象
  TouchGlobalEvent =
  {
    TOUCH_PRESS   = 1,
    TOUCH_RELEASE = 2,
    TOUCH_MOVE    = 3,
  };

  GestureGlobalEvent =
  {
    GESTURE_BEGIN = 1,
    GESTURE_KEEP = 2,
    GESTURE_END = 3,
  };

  GestureScalePath  = "GestureScaleComponent" ; -- 相当于全局的组件: 手势缩放组件
  GestureRotatePath = "GestureRotateComponent" ; -- 相当于全局的组件: 旋转缩放组件

  ScreenRotationChangePath = "ScreenRotationChangePath";
  ScreenRotationEvent = {
    SCREEN_ROTATION_CHANGE = 1
  };

  VirtualEvent =
  {
    HasFace = cv.RecognitionComponent.cvFace +  2*1, -- cv* 是个位标记 这里0x3 不会跟其他冲突
    HasCat = cv.CatFaceComponent.cvCatface +  2*1, -- cv* 是个位标记 这里0x3 不会跟其他冲突
    HasPlane = 5, -- cvFace相关事件占用1, 2, 3, 4, 8
  };


};

BlueDefined.RequestType = {
  PHOTO = 0,
  VIDEO = 1,
  AUDIO = 2,
  TEXT  = 3,      -- 素材动态资源
  TEMPERATURE = 4,
  LOCATION    = 5,
  WEATHER     = 6,-- 环境信息
  NICK_NAME   = 7,
  USER_ID     = 8,
  BIRTH_DAY   = 9,
  USER_GRADE  = 10,-- 用户信息
  PHOTO_VIDEO = 11,
  VIBRATE = 12,
  EMOJI = 13,-- EMOJI图片
  REFRESH_FRAME = 14, --请求刷新画面
  VIBRATE = 12,
  UN_LOAD  = 13,
}


BlueDefined.FuncType = {
  LOCAL = 0,
  GLOBAL = 1,
  EVENT = 2,
  DISPATCHER = 3,
}

--bluefunction过滤节点
BlueDefined.FuncFilterList = 
{
  CATALOGUE = {"event"},
  NODELIST = {"bluecore.bluenodes.controlflow.delay"}
}

BlueDefined.SIGNATURE = "Blue_"
BlueDefined.REGULAR = "^Blue_"
BlueDefined.EVENT_PREFIX = "E_"
BlueDefined.FUNC_PREFIX = "F_"
BlueDefined.DISPATHER_PREFIX = "D_"
BlueDefined.BPCLASS_PREFIX = "C_"
BlueDefined.BPCLASSVAR_PREFIX = "V_"
BlueDefined.BPFUNCVAR_PREFIX = "L_"

--改成端内不检查输入依赖错误
BlueDefined.STRICT_MODE = _KRATOSEDITOR;

return BlueDefined;

