
#DEFPARAMS
BRIGHT_TEXTURE = { "Bright Tex", TEXTURE2D, 0.0,0.0 },
UNIFORM_LIGHT_COLOR = { "Offset", VEC3, "0.0,0.0,0.0" },
SAMPLES = { "Samples", FLOAT, "0.0" },
STEP = { "Step", FLOAT, "0.0" },
CENTER = {"Center", VEC2, "0.0, 0.0"},
RATIO = {"Ratio", FLOAT, "0.0"},
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "ShineVolumnLight"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D BRIGHT_TEXTURE;
SamplerState BRIGHT_TEXTURE_Sampler;
float3 UNIFORM_LIGHT_COLOR;
float2 CENTER;
float SAMPLES;
float STEP;
float RATIO;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	int samples = int(SAMPLES);
	float2 texcoord = i.uv;
    float2 uv = i.uv; 

	float2 tuv =  uv - float2(CENTER.x, -CENTER.y);
	float dis = length(tuv);
	
	#ifdef POST_EFFECT_ALPHA_OFF
		float2 dTuv = dis > samples * STEP ? normalize(tuv) * STEP: tuv / samples;
		float3 sum_brightness = float3(0.0, 0.0, 0.0);
	
		float delta_step = 1.0 / samples;
		float cur_dis = 1.0;
		for(int i= 0; i < samples; i++)
		{
			uv -= dTuv;
			sum_brightness += BRIGHT_TEXTURE.Sample(BRIGHT_TEXTURE_Sampler, uv).rgb  * 0.05 * cur_dis * cur_dis;
			cur_dis -= delta_step;
		}
		float3 rgb = BRIGHT_TEXTURE.Sample(BRIGHT_TEXTURE_Sampler, texcoord).xyz;
		float cRATIO = clamp(RATIO, 0.0, 1.0);
		float3 res_color = rgb + (UNIFORM_LIGHT_COLOR * cRATIO + float3(1.0 - cRATIO,1.0 - cRATIO,1.0 - cRATIO)) * sum_brightness;
		mainColor = float4(res_color, 1.0);
	#elif POST_EFFECT_ALPHA_ON
		float2 dTuv = dis > samples * STEP ? normalize(tuv) * STEP: tuv / samples;
		float4 sum_brightness = float4(0.0, 0.0, 0.0, 0.0);
	
		float delta_step = 1.0 / samples;
		float cur_dis = 1.0;
		for(int i= 0; i < samples; i++)
		{
			uv -= dTuv;
			sum_brightness += BRIGHT_TEXTURE.Sample(BRIGHT_TEXTURE_Sampler, uv)  * 0.05 * cur_dis * cur_dis;
			cur_dis -= delta_step;
		}
		float4 rgba = BRIGHT_TEXTURE.Sample(BRIGHT_TEXTURE_Sampler, texcoord);
		float cRATIO = clamp(RATIO, 0.0, 1.0);
		float3 res_color = rgba.rgb + (UNIFORM_LIGHT_COLOR * cRATIO + float3(1.0 - cRATIO,1.0 - cRATIO,1.0 - cRATIO)) * sum_brightness.rgb;
		float alpha = rgba.a + sum_brightness.a;
		mainColor = float4(res_color, alpha);
	#endif
}
ENDCG
#END
