#pragma once

#include "shadow.inc"

#define e 2.71828183

#if ShadowOn


Texture2D TEXTURE_HAIR_SHADOW_DEPTH;
Texture2D TEXTURE_HAIR_SHADOW_MASK;

SamplerState TEXTURE_HAIR_SHADOW_DEPTH_SAMPLER;
SamplerState TEXTURE_HAIR_SHADOW_MASK_SAMPLER;


float ComputeShadowAttenuationHair(float2 UV, float Z, float fFiberSpacing, float fFiberRadius, float fHairshaowAlpha)
{
    float Sample = TEXTURE_HAIR_SHADOW_DEPTH.Sample(TEXTURE_HAIR_SHADOW_DEPTH_SAMPLER, UV).r;
    
    if(Z < Sample)
    {
        return 1.0;
    }
    else
    {
        float fDepthDistanceWS = Z - Sample;
        float numFibers = fDepthDistanceWS/(fFiberRadius*fFiberSpacing);
        
        if(fDepthDistanceWS > 1e-5)
          numFibers = max(numFibers, 1);

        return pow(abs(1-fHairshaowAlpha), numFibers);
    }
}

float PCFNoHardwareSupportHair(float4 coord, float4 _ShadowMapTexture_TexelSize, float fFiberSpacing, float fFiberRadius, float fHairshaowAlpha, int radius = 2)
{
    float shadow = 0.0;
    float2 base_uv = coord.xy;
    float2 ts = _ShadowMapTexture_TexelSize.xy;

    const int kernelLevel = radius;
    const int kernelWidth = 2 * kernelLevel + 1;
    [unroll] for(int i = -kernelLevel; i<= kernelLevel; i++)
    {
        [unroll] for(int j = -kernelLevel; j<= kernelLevel; j++)
        {
            float2 uvDisplace = float2(i, j) * ts;
            shadow += ComputeShadowAttenuationHair(base_uv + uvDisplace, coord.z, fFiberSpacing, fFiberRadius, fHairshaowAlpha);
        }
    }

    shadow /= ( kernelWidth * kernelWidth);

    return shadow;

}




#if DirLight
float GetHairShadowAtten(float4 shadowCoord, float fFiberSpacing, float fFiberRadius, float fHairshaowAlpha)
{
    if (shadowCoord.w > CAMERA_SHADOWRANGE.x)
    {
        return 1.0;
    }

    float2 shadowsize = float2(LIGHT_PARAM.z, LIGHT_PARAM.z);
    float4 _ShadowMapTexture_TexelSize = float4(shadowsize.x, shadowsize.y, 1.0/shadowsize.x, 1.0/shadowsize.y);

    shadowCoord.y = 1.0 - shadowCoord.y;
       
    float shadow = PCFNoHardwareSupportHair(shadowCoord, _ShadowMapTexture_TexelSize, fFiberSpacing, fFiberRadius, fHairshaowAlpha);   

    shadow = lerp(1.0, shadow, LIGHT_PARAM.y);
    return shadow;
}

float GetShadowCastByHair(float4 shadowCoord, float strength)
{
    if (shadowCoord.w > CAMERA_SHADOWRANGE.x)
    {
        return 1.0;
    }
    shadowCoord.y = 1.0 - shadowCoord.y;

    float shadow = TEXTURE_HAIR_SHADOW_MASK.Sample(TEXTURE_HAIR_SHADOW_MASK_SAMPLER, shadowCoord.xy);

    shadow = (shadow < 1.0 )? shadow * saturate(strength) : shadow;

    return shadow;
}

#else

float GetHairShadowAtten(float4 shadowCoord, float fFiberSpacing, float fFiberRadius, float fHairshaowAlpha)
{
    shadowCoord.y = 1.0 - shadowCoord.y;

    float2 shadowsize = float2(LIGHT_PARAM.z, LIGHT_PARAM.z);
    float4 _ShadowMapTexture_TexelSize = float4(shadowsize.x, shadowsize.y, 1.0/shadowsize.x, 1.0/shadowsize.y);

    float shadow = PCFNoHardwareSupportHair(shadowCoord, _ShadowMapTexture_TexelSize, fFiberSpacing, fFiberRadius, fHairshaowAlpha);   

    shadow = lerp(1.0, shadow, LIGHT_PARAM.y);
    return shadow;
}

float GetShadowCastByHair(float4 shadowCoord, float strength)
{
    shadowCoord.y = 1.0 - shadowCoord.y;

    float shadow = TEXTURE_HAIR_SHADOW_MASK.Sample(TEXTURE_HAIR_SHADOW_MASK_SAMPLER, shadowCoord.xy);

    shadow = (shadow < 1.0 )? shadow * saturate(strength) : shadow;
    return shadow;
}

#endif
#endif



#if ShadowOn
    #if DirLight
    #define TRANSFER_HAIRSHADOW(o, shadowcoord) o._ShadowCoord = shadowcoord.xyzw / shadowcoord.w;\
                        float4 viewSpacePos = mul(o._ShadowCoord, CAMERA_VIEWPROJ_INV);\
                        viewSpacePos /= viewSpacePos.w;\
                        viewSpacePos = mul(viewSpacePos, CAMERA_VIEW);\
                        o._ShadowCoord.xyz = o._ShadowCoord.xyz * 0.5 + 0.5;\
                        o._ShadowCoord.w = - viewSpacePos.z
    #define SHADOW_ATTEN_HAIR(o, fFiberSpacing, fFiberRadius, fHairshaowAlpha) GetHairShadowAtten(o._ShadowCoord, fFiberSpacing, fFiberRadius, fHairshaowAlpha)
    #define SHADOW_ATTEN_BYHAIR(o, strength) GetShadowCastByHair(o._ShadowCoord, strength)

    #elif SpotLight
    #define TRANSFER_HAIRSHADOW(o, shadowcoord) o._ShadowCoord = shadowcoord.xyzw / shadowcoord.w;\
                        o._ShadowCoord.xyz = o.Hair_ShadowCoord.xyz * 0.5 + 0.5;\
                        o._ShadowCoord.w = 1.0
    #define SHADOW_ATTEN_HAIR(o, fFiberSpacing, fFiberRadius, fHairshaowAlpha) GetHairShadowAtten(o._ShadowCoord, fFiberSpacing, fFiberRadius, fHairshaowAlpha)
    #define SHADOW_ATTEN_BYHAIR(o, strength) GetShadowCastByHair(o._ShadowCoord, strength)

    #else
    #define TRANSFER_HAIRSHADOW(o, shadowcoord) float4 lightCoordBuiltin = float4(1.0, 1.0, 1.0, 1.0)
    #define SHADOW_ATTEN_HAIR(o, fFiberSpacing, fFiberRadius, fHairshaowAlpha) 1.0
    #define SHADOW_ATTEN_BYHAIR(o, strength) 1.0
    #endif

#else
    #define TRANSFER_HAIRSHADOW(o, shadowcoord) float4 lightCoordBuiltin = float4(1.0, 1.0, 1.0, 1.0)
    #define SHADOW_ATTEN_HAIR(o, fFiberSpacing, fFiberRadius, fHairshaowAlpha) 1.0
    #define SHADOW_ATTEN_BYHAIR(o, strength) 1.0
#endif


