#SHADER_DEFINE MaskingVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE MaskingFragment

    FUNCTION_INPUT = 
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { TEXTURE_MASKING,           NONE,      TEXTURE2D,   "in_MaskingTexture" },
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate" },
    }

#SHADER_CODE
    
    vec3 color = texture2D(in_DiffuseTexture, in_TexCoordinate).rgb;
    float alpha = texture2D(in_MaskingTexture, in_TexCoordinate).r;
    gl_FragColor = vec4(color, alpha);

#END_CODE
#END_DEFINE







