//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////
#include "functions/helperfunc.function"
#include "functions/noise3d.function"

#SHADER_DEFINE EmitterSpeed

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION,		MEDIUM,	VEC3,	"in_Center" },
		{ ATTRIBUTE_EMITTER_SPEED,			MEDIUM,	VEC3,	"in_Speed" },
		{ EMITTER_AGE,				HIGH,	FLOAT,	"in_Age" },
   
	}

	FUNCTION_OUTPUT = 
	{
		{ LOCALSPACE_POSITION,		MEDIUM,	VEC3,	"out_NewCenter" },
    { PARTICLE_SPEED,     MEDIUM,  VEC3, "out_Speed"},
	}

#SHADER_CODE
	vec3 out_NewCenter = in_Center;
	out_NewCenter += in_Speed * in_Age;
  out_Speed = in_Speed;
#END_CODE
#END_DEFINE

#SHADER_DEFINE GravitySpeed

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_EMITTER_SPEED,	            MEDIUM,	VEC3,		  "in_initSpeed"},
    { EMITTER_AGE,				HIGH,	FLOAT,	"in_time" },
	}

	FUNCTION_OUTPUT = 
	{
		{ LOCALSPACE_POSITION,		MEDIUM,	VEC3,	"out_NewCenter" },
    { PARTICLE_SPEED,     MEDIUM,  VEC3, "out_Speed"},
	}
	
#SHADER_CODE
    float positionY = in_initSpeed.y * in_time + 0.5 * -9.8 * in_time * in_time;
    float positionX = in_initSpeed.x * in_time;
    float positionZ = in_initSpeed.z * in_time;
    vec3 out_NewCenter = vec3(positionX,positionY,positionZ);
    vec3 out_Speed = vec3(in_initSpeed.x, in_initSpeed.y + -9.8 * in_time, in_initSpeed.z);
#END_CODE
#END_DEFINE

#SHADER_DEFINE BezierCurveSpeed
	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_POSITION,		MEDIUM,	VEC3,	"in_Center" },
    { ATTRIBUTE_EMITTER_LIFE,	HIGH,	FLOAT,	"in_Life" },
		{ EMITTER_AGE,				    HIGH,	FLOAT,	"in_Age" },
    { ATTRIBUTE_EMITTER_SPEED,			MEDIUM,	VEC3,	"in_Speed" },
    { BEZIER_SPEED_ONE,       LOW,  VEC3,   "in_control_speed_1"},
    { BEZIER_SPEED_TWO,       LOW,  VEC3,   "in_control_speed_2"},
    { BEZIER_SPEED_THREE,       LOW,  VEC3,   "in_control_speed_3"},
    { BEZIER_SPEED_FOUR,       LOW,  VEC3,   "in_control_speed_4"},
	}

	FUNCTION_OUTPUT = 
	{
    { LOCALSPACE_POSITION,		MEDIUM,	VEC3,	"out_NewCenter" },
    { PARTICLE_SPEED,     MEDIUM,  VEC3, "out_Speed"},
	}
	
#SHADER_CODE
  //控制点控制的是速度的大小和世界方向
  vec4 controlp1 = vec4(in_Speed.x * in_control_speed_1.x,in_Speed.y * in_control_speed_1.y,in_Speed.z * in_control_speed_1.z,0.0);
  vec4 controlp2 = vec4(in_Speed.x * in_control_speed_2.x,in_Speed.y * in_control_speed_2.y,in_Speed.z * in_control_speed_2.z,0.0);
  vec4 controlp3 = vec4(in_Speed.x * in_control_speed_3.x,in_Speed.y * in_control_speed_3.y,in_Speed.z * in_control_speed_3.z,0.0);
  vec4 controlp4 = vec4(in_Speed.x * in_control_speed_4.x,in_Speed.y * in_control_speed_4.y,in_Speed.z * in_control_speed_4.z,0.0);
    
  //计算积分
  //计算有问题
  float speedt = in_Age / in_Life;
  float speedt2 = speedt * speedt;
  float one_minus_speedt = 1.0 - speedt;
  float one_minus_speedt2 = one_minus_speedt * one_minus_speedt;
  vec3 fb = ((-0.25 * (1.0 - speedt) * (1.0 - speedt) * (1.0 - speedt) * (1.0 - speedt)) * controlp1 + 
            (1.5 * speedt * speedt + 3.0 / 4.0 * speedt * speedt * speedt * speedt - 2.0 * speedt * speedt * speedt) * controlp2 + 
            (speedt * speedt * speedt - 3.0 / 4.0 * speedt * speedt * speedt * speedt) * controlp3 + 
            (0.25 * speedt * speedt * speedt * speedt) * controlp4).xyz;
  vec3 fa = (-0.25 * controlp1).xyz;
  vec3 s = (fb - fa) * in_Life;
  vec3 out_NewCenter = in_Center;
  out_NewCenter += s;
  
  
  
  //重力影响
  //float positionY_gravity = in_Speed.y * in_Age + 0.5 * -9.8 * in_Age * in_Age;
  //float positionX_gravity = in_Speed.x * in_Age;
  //float positionZ_gravity = in_Speed.z * in_Age;
  //vec3 NewPosition_gravity = vec3(positionX_gravity,positionY_gravity,positionZ_gravity);
	//out_NewCenter += NewPosition_gravity;
  
  
  //out_NewCenter.x = out_NewCenter.x + 0.05 * getNoiseOffset(s).x;
  //out_NewCenter.z = out_NewCenter.z +  0.05 * getNoiseOffset(s).z;
  
  //输出速度
  vec3 out_Speed = (controlp1 * one_minus_speedt2 * one_minus_speedt + controlp2 * 3.0 * speedt * one_minus_speedt2 + controlp3 * 3.0 * speedt2 * one_minus_speedt + controlp4 * speedt2 * speedt).xyz;
#END_CODE
#END_DEFINE