
#DEFPARAMS

#END
 
   
#DEFTAG
ShaderName = "reflection"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

Texture2D TEXTURE_MAINTEX;
Texture2D TEXTURE_RAYMARCH;

SamplerState TEXTURE_MAINTEX_SAMPLER;
SamplerState TEXTURE_RAYMARCH_SAMPLER;

float2 texSize;

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	float2 texCoords = i.uv;
	float4 ray = TEXTURE_RAYMARCH.Sample(TEXTURE_RAYMARCH_SAMPLER, texCoords);
	float alpha = ray.b;
	float2 coord = ray.rg;
	//remove holes
	/*
	if(alpha <= 0.0)
	{
		int   size       = 6;
		float separation = 2.0;
		coord    = vec2(0.0);
		alpha    = 0.0;
		int count = 0;

		for (int i = -size; i <= size; ++i) {
			for (int j = -size; j <= size; ++j) {
				float3 samp = TEXTURE_RAYMARCH.Sample( TEXTURE_RAYMARCH_SAMPLER, ( texCoords + float2(i, j) * separation) / texSize).xyz;
				if(samp.z > 0.0)
				{
					coord += samp.xy;
					alpha += samp.z;
					count += 1.0;
				}
			}
		}
		if(count > 0)
		{	
			coord /= count;
			alpha /= count;		
		}

	}
	*/

	if (alpha <= 0.0) 
	{ 
		outColor = float4(0.0,0.0,0.0,0.0); 
		return;
	}
	
	float4 reflected = TEXTURE_MAINTEX.Sample(TEXTURE_MAINTEX_SAMPLER, coord);
    
	outColor.rgba = float4(reflected.xyz, alpha);

}

ENDCG
#END

