#DEFPARAMS
TEXTURE_DIFFUSE = { "Texture Diffuse", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "sRGB2Linear"
RenderQueue = "POSTEFFECT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"


struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_SAMPLER;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
    float4 texcolor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, i.uv);
    float4 out_SurfaceColor =  float4(GammaToLinearSpaceExact(texcolor.r),GammaToLinearSpaceExact(texcolor.g),GammaToLinearSpaceExact(texcolor.b),texcolor.a);
    outColor = out_SurfaceColor;
}
 
ENDCG
#END