#DEFPARAMS
#END

#DEFTAG
ShaderName = "hairShadowMask"
RenderQueue = "Opaque"
#END

#DEFPASS Hair_Clear_Copy
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_GREATER }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"


struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};


struct ps_out 
{
    float4 mainColor : SV_Target0;
    float depth      : SV_Depth;
};


Texture2D TEXTURE_SCENE_DEPTH;
SamplerState TEXTURE_SCENE_DEPTH_SAMPLER;

v2f vert(appdata v)
{
    v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}


ps_out frag(in v2f v)
{
    ps_out o;

    float sceneDepth = TEXTURE_SCENE_DEPTH.Sample(TEXTURE_SCENE_DEPTH_SAMPLER, v.uv).r;
    
    o.depth     = sceneDepth;
    o.mainColor = float4(0.5, 0, 0, 1.0);
    return o;
}
ENDCG
#END
