#include"functions/adjust.function"

#SHADER_DEFINE ToningVertex
	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE



#SHADER_DEFINE ToningFragment
  FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { RED_TONING, 		HIGH,	VEC4,		"red_toning"},
    { GREEN_TONING, 		HIGH,	VEC4,		"green_toning"},
    { BLUE_TONING, 		HIGH,	VEC4,		"blue_toning"},
	}
#SHADER_CODE
     vec3 rgb = texture2D(uniCurrentTexture,in_TexCooridate).rgb;
     rgb.r = adjust(red_toning.x,red_toning.y,red_toning.z,red_toning.w,rgb.r);
     rgb.g = adjust(green_toning.x,green_toning.y,green_toning.z,green_toning.w,rgb.g);
     rgb.b = adjust(blue_toning.x,blue_toning.y,blue_toning.z,blue_toning.w,rgb.b);
     gl_FragColor = vec4(rgb,1.0);
  
#END_CODE
#END_DEFINE