#DEFPARAMS
_MainTex = { "Main Color", TEXTURE2D, "white" },
_MaskTex = { "Mask Color", TEXTURE2D, "white" },
_BlendTex = { "Blend Color", TEXTURE2D, "white" },
_MetallicGlossMap = {"Metallic Gloss", TEXTURE2D, "white"},
_BumpMap = {"Normal Map", TEXTURE2D, "bump"},
_GlossEnvMap = {"Specular IBL Map", TEXTURECUBE, "black"},
_IrradianceMap = {"Diffuse IBL Map",TEXTURECUBE,"black"},
_Smoothness = {"Smoothness", FLOAT, "0.5" },
_Metallic = { "Metallic", FLOAT, "0.5" },
_EmissionColor = {"Emission Color", COLOR, "0.0,0.0,0.0,1.0"},
_EmissionMap = {"Emission Map",TEXTURE2D,"white"},
_Opacity = { "Opacity", FLOAT, "1.0" },
[Enum(Normal,1.0,Add,2.0,Screen,3.0,Overlay,4.0,SoftLight,5.0,Lighten,6.0,Multiply,7.0)]
_BlendType = { "BlendType", FLOAT, "1.0" },
[Enum(DepthMode)]
_DepthState = {"Depth State", FLOAT, "1.0"},
[Enum(DepthFunc)]
_DepthFc = {"Depth Test", FLOAT, "1.0"},
[Enum(CullMode)]
_CullMode = {"Cull Mode", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "StandardPbr"
RenderQueue = "Transparent"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { "%_CullMode", DEPTH_MASK_ON, "%_DepthState", "%_DepthFc" }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#define GammaSpace 1
#include "lightpbr.inc"
#include "blendmakeupfunc.inc"
struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 dstuv : TEXCOORD4;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(5)
};

Texture2D _MainTex;
Texture2D _MaskTex;
Texture2D _BlendTex;
Texture2D _MetallicGlossMap;
Texture2D _BumpMap;
Texture2D _EmissionMap;
TextureCube _GlossEnvMap;
TextureCube _IrradianceMap;

SamplerState _MainTexSampler;
SamplerState _MaskTexSampler;
SamplerState _BlendTexSampler;
SamplerState _MetallicGlossMapSampler;
SamplerState _BumpMapSampler;
SamplerState _EmissionMapSampler;
SamplerState _GlossEnvMapSampler;
SamplerState _IrradianceMapSampler;

float _Smoothness;
float _Metallic;
float4 _EmissionColor;
float _Opacity;
float _BlendType;
v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	o.dstuv = pos;
	o.dstuv.xy = o.dstuv.xy * 0.5 + 0.5 * o.dstuv.ww;
	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	// sample the texture
	float4 col = _MainTex.Sample(_MainTexSampler, i.uv);
	float2 mg = _MetallicGlossMap.Sample(_MetallicGlossMapSampler, i.uv).ra;
	//float emissionMask = tex2D(_MetallicGlossMap, i.uv).g;
	float3 emissionMapColor = _EmissionMap.Sample(_EmissionMapSampler,i.uv).rgb;
	float3 normalTangent = _BumpMap.Sample(_BumpMapSampler, i.uv).rgb;
	normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
	float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldtangent.xyz
		+ normalTangent.z * i.worldnormal.xyz;
	normalWorld.xyz = normalize(normalWorld.xyz);

	float roughness = 1.0 - mg.g * _Smoothness;
	float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	float3 iblColor = SpecularIBLColor(_GlossEnvMap, _GlossEnvMapSampler, worldPos, normalWorld, roughness);
	float3 iblDiffuseColor = DiffuseIBLColor(_IrradianceMap, _IrradianceMapSampler, worldPos, normalWorld);

	SurfaceStandardInput input;
	input.albedo = col.rgb;
	input.metallic = mg.r * _Metallic;
	input.smoothness = mg.g * _Smoothness;
	input.worldNormal = normalWorld; // normalWorld;
	input.worldPos = worldPos;
	input.emission = AmbientColor() + _EmissionColor.rgb * emissionMapColor;// * emissionMask;
	input.specularIbl = iblColor.rgb;
	input.diffuseIbl = iblDiffuseColor.rgb;
	input.atten = SHADOW_ATTEN(i);
	input.alpha = col.a;

	outColor.xyz = PBR_LightCalc(input);
	
	float4 maskCol = _MaskTex.Sample(_MaskTexSampler, i.uv);
	outColor.w = col.a * maskCol.a * _Opacity;
	
	float3 screenPos = i.dstuv.xyz/i.dstuv.w;
	float2 uv = screenPos.xy;
	float4 dstColor = _BlendTex.Sample(_BlendTexSampler,float2(uv.x,1.0 - uv.y));
	float4 srcColor = outColor;
  	int iBlendMode = int(_BlendType);
	outColor.w = col.a * maskCol.a * _Opacity;
	outColor.xyz = blendmakeup(iBlendMode,srcColor,dstColor);
	outColor.w = 1.0;
}
ENDCG

#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#define GammaSpace 1
	#include "lightpbr.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
		ANI_ATTRIBUTE
	};

	struct v2f
	{
		float4 vertex : SV_POSITION;
	};

	v2f vert(appdata v)
	{
		COMPUTE_BONE_MATERIX(v);

		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	void frag(in v2f i, out float4 outColor : SV_Target0)
	{
		outColor = float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END