

#DEFPARAMS
DILATE_STEP = { "DILATE_STEP", VEC2, "5.0,5.0" },
INPUTSIZE = { "INPUTSIZE", VEC2, "500.0,500.0" },
#END

#DEFTAG
ShaderName = "Dilate_Circle_Y"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_SAMPLER;
float2 INPUTSIZE;
float2 DILATE_STEP;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;


	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	float4 color = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, i.uv);
	float2 step = DILATE_STEP / (INPUTSIZE);
	float color_max = color.a;
	float halfWidth = 1;//max(max(step.x, step.y) / 2, 1);
	float2 onestep = step / halfWidth;
	
	int j = 4;
	//for (; j<=halfWidth; j++)
	{
		float2 step =  j*onestep;
		float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
		float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
		color_max = max(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, uv1).a, color_max);
		color_max = max(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, uv2).a, color_max);
	}
	 j = 12;
	//for (; j<=12*halfWidth; j++)
	{
		float2 step =  j*onestep;
		float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
		float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
		color_max = max(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, uv1).b, color_max);
		color_max = max(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, uv2).b, color_max);
	}
	 j = 16;
	//for (; j<=16*halfWidth; j++)
	{
		float2 step =  j*onestep;
		float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
		float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
		color_max = max(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, uv1).g, color_max);
		color_max = max(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, uv2).g, color_max);
	}
	 j = 19;
	//for (; j<=9*halfWidth; j++)
	{
		float2 step =  j*onestep;
		float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
		float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
		color_max = max(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, uv1).r, color_max);
		color_max = max(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, uv2).r, color_max);
	}

	// float2 step =  onestep;
	// float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
	// float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
	// color_max = max(tex2D(TEXTURE_DIFFUSE, uv1).b, color_max);
	// color_max = max(tex2D(TEXTURE_DIFFUSE, uv2).b, color_max);
	
	// step =  2*onestep;
	// uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
	// uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
	// color_max = max(tex2D(TEXTURE_DIFFUSE, uv1).g, color_max);
	// color_max = max(tex2D(TEXTURE_DIFFUSE, uv2).g, color_max);

	// step =  3*onestep;
	// uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
	// uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
	// color_max = max(tex2D(TEXTURE_DIFFUSE, uv1).g, color_max);
	// color_max = max(tex2D(TEXTURE_DIFFUSE, uv2).g, color_max);

	// step =  4*onestep;
	// uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
	// uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
	// color_max = max(tex2D(TEXTURE_DIFFUSE, uv1).r, color_max);
	// color_max = max(tex2D(TEXTURE_DIFFUSE, uv2).r, color_max);

	outColor = float4(color_max, color_max, color_max, color_max);
}
ENDCG
#END
