local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local apollonode = require "apolloutility.apollonode"
local Object = require "classic"


local EnvironmentConfig = Object:extend();

function EnvironmentConfig:new(mainCamera,maxShadowDistance)
  self.ambient = nil;
  self.direct = nil;
  self.shadowcamera = nil;
  self.transparentshadowcamera = nil;
  self.lightRotation = nil;
  self.shadowQuatity = apolloengine.IPipelineSystem.SQ_HIGH;
  
  local shadowDistance = maxShadowDistance or 1.0;
  apolloengine.IPipelineSystem:SetMainCamera(mainCamera:GetNode());
  apolloengine.IPipelineSystem:SetMaxShadowDistance(shadowDistance);
  apolloengine.IEnvironmentSystem:EnableShadow();  --默认开启阴影
end

--环境光
function EnvironmentConfig:AmbientLight(color)
  self.ambient = apollonode.LightNode(apolloengine.LightComponent.LT_AMBIENT);
  self.ambient:SetColor(color);
end

--方向光
function EnvironmentConfig:DirectionLight(direction,color)
  self.direct = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
  self.direct:SetColor(color);
  self.direct:SetLocalDirection(direction);
  --OPAQUE_SHADOW
  self.direct:EnableShadowCaster(apolloengine.LightComponent.OPAQUE_SHADOW);   --打开投射阴影
  self.shadowcamera, self.transparentshadowcamera = self.direct:GetShadowCamera();
  self.rotation = self.direct:GetLocalRotation();
  self.direction = direction;
  
  --模糊阴影图
  --self.post = apollonode.PostEffect(); 
  --self.post:CreateResource("docs:superme3d/Shadow/shadowblur.lua");
  --self.shadowcamera:AttachPostEffect(self.post);
  
  --self.post2 = apollonode.PostEffect();
  --self.post2:CreateResource("docs:superme3d/Shadow/shadowblur.lua");
  --self.transparentshadowcamera:AttachPostEffect(self.post2);
  
end

function EnvironmentConfig:RotateDirectionLight(rot)
  --self.direction = self.direction * rot;
  self.direct:SetLocalRotation(rot);
  --self.direct:SetLocalDirection(self.direction);
end


function EnvironmentConfig:SetShadowQuality(quality)
  self.shadowQuatity = quality;
end

--阴影总开关
function EnvironmentConfig:EnableShadow()
  apolloengine.IPipelineSystem:SetShadowQuality(self.shadowQuatity);
  apolloengine.IEnvironmentSystem:EnableShadow();
end

--阴影总开关
function EnvironmentConfig:DisableShadow()
  apolloengine.IEnvironmentSystem:DisableShadow();
end

function EnvironmentConfig:EnableDirectionShadowCaster(shadowType)
  self.direct:EnableShadowCaster(shadowType);
end


function EnvironmentConfig:DisableDirectionShadowCaster()
  --self.lightnode:DisableTransparentShadowCaster();
  --self.lightnode:DisablePostEffect();
  self.direct:DisableShadowCaster();
  self.direct:DisablePostEffect();
end



return EnvironmentConfig;