  
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local photomooddef = require "photomood.defined"
local Object = require "classic"
local likeapp = require "likeapp"
local defined = require "apolloutility.defiend"
local renderqueue = require "apolloutility.renderqueue"




local BaseSequenceBlend = Object:extend();

function BaseSequenceBlend:new(rows,cols,location,alphamode,maincamera)
  local maincamera = renderqueue:GetCamera("Output");
  self.rows = rows;
  self.cols = cols;
  self.location = location;
  self.alphamode = alphamode;
  self.isShow = nil;

  if alphamode == nil or alphamode == "Add" or alphamode == "Blend" then
    self.isblend = false;
  else
    self.isblend = true;
    self:_CreateCameraRendertarget();

    self.blend = maincamera:CreatePostEffect();
    self.blend:CreateResource(photomooddef.BlendMode[self.alphamode]);
    self.blend:RegisterParameter("blendtex");
    self.blend["blendtex"](self.blend, self.tex)

    self.blend:Disable();

  end

  self.quadnode = apollonode.QuadNode();
  self.quadnode:SetShow(false);


  apolloengine.ShaderEntity.TEXTURE_LOCATION =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_LOCATION");
  apolloengine.ShaderEntity.TEXTURE_SPLIT_INFO =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_SPLIT_INFO");

  local baseStrMaterial = self:AssemblyMaterial();
  self.quadnode:CreateResourceByMaterialBuffer(baseStrMaterial, false);


end

function BaseSequenceBlend:AssemblyMaterial()
    
    local alphamode_str = photomooddef.AlphaMode[self.alphamode];
    local shaderpart_str = photomooddef.Shaders["BaseVideo"];
    if alphamode_str == nil then
        alphamode_str = "{ ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA , ONE, ONE }"; --默认混合模式
    end
    
    local material_begin = "";
    if self.isblend == true then
      alphamode_str = "{ ALPAH_OFF }";
      material_begin = string.format(photomooddef.base_material_begin,"OPAQUE",alphamode_str);
    else
      material_begin = string.format(photomooddef.base_material_begin,"OPAQUE + 10",alphamode_str);
    end
    
    local materialsrc = material_begin .. shaderpart_str;
    materialsrc = materialsrc .. photomooddef.material_end;

    --LOG(materialsrc);
    return materialsrc;
    
end


function BaseSequenceBlend:SetSequence(s)
    if self.isblend == true then
      self.quadnode:SetSequence(photomooddef.photomood_base_blend_camera_sequence);
    else
      self.quadnode:SetSequence(s);
    end
end

function BaseSequenceBlend:After()
  if self.isblend == true then
    self.quadnode:SetSequence(photomooddef.photomood_base_blend_camera_sequence);
  else
    renderqueue:After(self.quadnode);
  end
end

function BaseSequenceBlend:SetShow(isShow)
  if self.isShow ~= isShow then
    self.isShow = isShow;
    self.quadnode:SetShow(isShow);
    if self.isblend == true then
      self.blend:Enable();
    end
    
  end
end

function BaseSequenceBlend:Update()
    
    local diffuse_texture = videodecet:GetVideoTexture();
    local textureLoc = mathfunction.vector2(self.location[1],self.location[2]);
    local textureSplitInfo = mathfunction.vector2(self.rows,self.cols);
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_LOCATION,textureLoc);
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_SPLIT_INFO,textureSplitInfo);
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuse_texture); 
    
    self:SetShow(true);  --始终显示
end

function BaseSequenceBlend:_CreateCameraRendertarget()
  local maincamera = renderqueue:GetCamera("Output");
  local near = maincamera:GetNear();
  local far = maincamera:GetFar();
  local pos = maincamera:GetWorldPosition();
  local lookat = pos + maincamera:GetForward();
  local up = maincamera:GetUp();
  local color = mathfunction.Color(1.0,0.0,0.0,0.0); --清屏颜色
  
  self.historical_camera = apollonode.CameraNode();
  self.historical_camera:Activate();
  self.historical_camera:CreateRealCameraProjection(near, far);
  self.historical_camera:LookAt(pos, lookat, up);
  self.historical_camera:SetSequence(photomooddef.photomood_base_blend_camera_sequence);
  self.historical_camera:SetClearColor(color);
  
  self.rt = apolloengine.RenderTargetEntity();
  --self.rt = self.historical_camera:CreateRenderTarget();
  self.rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      apolloengine.Framework:GetViewport(),
      apolloengine.Framework:GetResolution()));--分辨率
  
  self.tex = self.rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.tex:PushMetadata(--创建纹理
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      apolloengine.Framework:GetResolution()));
  self.rt:CreateResource();
  self.historical_camera:AttachRenderTarget(self.rt);
end

function BaseSequenceBlend:Clear()
  --主动删除下
  local maincamera = renderqueue:GetCamera("Output");
  if self.isblend then
    LOG("BaseSequenceBlend:Clear()");
    self.blend:Disable();
    maincamera:DeletePostEffect(self.blend);
    self.blend = nil;
    self.rt = nil;
    self.tex = nil;
    self.historical_camera:Destroy();
    collectgarbage();
  end
  self.quadnode:Destroy();
end
return BaseSequenceBlend;
