local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

require "utility"

local denoise = {};


--size,video表示视屏纹理尺寸和id,size为table
function denoise:Initialize()
  
  self.node=apollonode.QuadNode();
 

  apolloengine.ShaderEntity.UNIFORM_WIDTH_OFFSET =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_WIDTH_OFFSET");
    
  apolloengine.ShaderEntity.UNIFORM_HEIGHT_OFFSET =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_HEIGHT_OFFSET");
  
  apolloengine.ShaderEntity.UNIFORM_OFFSETS =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"UNIFORM_OFFSETS");
    

  
  self.node:CreateResource("comm:documents/material/denoise.material",true);
  --self.node:CreateResource("docs:facecute/material/denoise.material",true);

  self.node:SetShow(true);
  self.node:SetCull(false);
  
  local tex = renderqueue:Queue(1,self.node);
  self.node:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, tex);
  
  self.resolution = apolloengine.Framework:GetResolution();
  
  self.height=self.resolution:y();
  self.hOffset=1.0/self.height;
  self.width=self.resolution:x();
  self.wOffset=1.0/self.width;
  
  
  
  self.offsets= mathfunction.vector2array();
  
  self.offsets:PushBack(mathfunction.vector2(-self.wOffset,  self.hOffset));
  self.offsets:PushBack(mathfunction.vector2(0.0, self.hOffset));
  self.offsets:PushBack(mathfunction.vector2(self.wOffset,self.hOffset));
  
  self.offsets:PushBack(mathfunction.vector2(-self.wOffset,0.0));
  self.offsets:PushBack(mathfunction.vector2(0.0,0.0));
  self.offsets:PushBack(mathfunction.vector2(self.wOffset,0.0));
  self.offsets:PushBack(mathfunction.vector2(-self.wOffset,-self.hOffset));
  self.offsets:PushBack(mathfunction.vector2(0.0,-self.hOffset));
  self.offsets:PushBack(mathfunction.vector2(self.wOffset,-self.hOffset));
  
 -- self.aspect_ratio = self.resolution:y()/self.resolution:x();
  
  self.node:SetParameter(apolloengine.ShaderEntity.UNIFORM_WIDTH_OFFSET, mathfunction.vector1(self.wOffset));  
  self.node:SetParameter(apolloengine.ShaderEntity.UNIFORM_HEIGHT_OFFSET, mathfunction.vector1(self.hOffset)); 
  
  self.node:SetParameter(apolloengine.ShaderEntity.UNIFORM_OFFSETS,self.offsets);

--  self.render:SetParameter(apolloengine.ShaderEntity.UNIFORM_RADIUS, mathfunction.vector1(0.08));  
--	float aspectRatio = 1.0 / 0.5625;

self.turnUp = 1;    --parameter to control the on and off of the denoise effect.
end


function denoise:TurnOn()
  
self.node:SetShow(true);
end


function denoise:TurnOff()
self.node:SetShow(false);
end



function denoise:Switch()
  
  self.turnUp=1-self.turnUp;
  if (self.turnUp == 1) 
  then
    self:TurnOn();
     LOG("turn on the denoise node: " );
  else
    self:TurnOff();
    LOG("turn off the denoise node: " );
  end
  
  
end


return denoise;
