local modelnodemodel = require "apolloutility.apollonode.modelnode"
local modelnode = require "apolloutility.apollonode.meshnode"
local skeletonnode = require "apolloutility.apollonode.skeletonnode"
local trasnnode = require "apolloutility.apollonode.trasnnode"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"
local vc = require "venuscore"

local modelnodehead = modelnodemodel:extend();

function modelnodehead:GetRenderOrder()
    local offset = -2000;
    if self.zPos~=nil then
        return self.zPos + offset;
    end
    return offset;
end
  
  
function modelnodehead:SetRenderOrder(zPos, bindBoxAdj)
    local offset = -2000;
    self.zPos = zPos;
    local bindBoxZ = offset + zPos + bindBoxAdj
    local bindboxV = mathfunction.Aabbox3d(
            mathfunction.vector3(-1, -1, bindBoxZ - 1),
            mathfunction.vector3( 1,  1, bindBoxZ));
    self:SetBindBox(bindboxV);
    --self:SetCull(false);
    for key, value in pairs(self.nodes) do
        LOG("SET RENDER ORDER:"..key.."TO:"..zPos);
        value:SetBindBox(bindboxV);
        value:SetCull(false);
    end
end

function modelnodehead:NeedSwap()
    return false;
end

function modelnodehead:IsRenderProperty(p)
    local ret = false;
    for key,value in pairs(self.nodes) do
      if value:IsRenderProperty(p) then
        return true;
      end
    end
  
    return false;
  end
  
return modelnodehead