local Object = require "classic"
local Liveportrait = require "liveportrait.liveportrait"


local LiveportraitBase = Object:extend();

function LiveportraitBase:new(start_time, last_time, fboSize)
  Liveportrait:Initialize(start_time, last_time);
  Liveportrait:SetFboSize(fboSize);
  self.PortraitTex = nil;
end

function LiveportraitBase:SetFboSize(size)
  Liveportrait:SetFboSize(size);
end

function LiveportraitBase:Update(def)
  Liveportrait:Update(def);
end

function LiveportraitBase:GetPortraitTex()
  if self.PortraitTex == nil then
    self.PortraitTex = Liveportrait:GetPortraitTex();
  end
  
 
  return self.PortraitTex;
end

function LiveportraitBase:LoadConfig(config)
  Liveportrait:LoadConfig(config)
end

function LiveportraitBase:SetAnimPath(anim_path)
  Liveportrait:SetAnimPath(anim_path)
end

function LiveportraitBase:UpdateMuglifeMaterial()
  Liveportrait:UpdateMuglifeMaterial()
end

function LiveportraitBase:Clear()
  Liveportrait:ReleaseResource();
end

-- This is to simulate windows env
function LiveportraitBase:IsMLInitDone()
  return Liveportrait:IsMLInitDone()
end

return LiveportraitBase;