local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
--local love2d = require "love2d"
local imguifunction = require "imguifunction"
local ImGui = imguifunction.ImGui;
local Attachmesh = venuscore.VenusBehavior:extend("AttachmeshBehavior");



function Attachmesh:new()
    self.isshow = nil
    self.initR = nil
	self.Node = nil
	self.attachRender = nil
	self.render = nil
	self.transform = nil
	self.attachTransform = nil
	self.run = false
	self.wposition = nil
	self.attachIdx = nil
	self.previousDist = nil
	self.hasChanged = false
end



function Attachmesh:GetAttachrender()
    return self.attachRender;
end

function Attachmesh:GetAttachtransform()
    return self.attachTransform;
end

function Attachmesh:SetAttachrender(attachRender)
    LOG("SET ATTACH RENDER")
    self.attachRender = attachRender
end

--传送回去trackingcomponent显示
function Attachmesh:getCoord()
	if self.wposition ~= nil then
		return {x = round(self.wposition:x(),4), y= round(self.wposition:y(),4),z = round(self.wposition:z(),4),idx = self.attachIdx}
	else
		return {x= nil, y = nil, z = nil,idx = nil}
	end
end


function Attachmesh:GetAttachIdx()
    return self.attachIdx;
end

--[[
function Attachmesh:SetAttachIdx(idx)
    LOG("SET ATTACH INDEX")
    self.attachIdx = idx
end


function Attachmesh:ConstraintVertex(maxVertex)
	if self.self.attachIdx<1 then
	  self.self.attachIdx = 1
	elseif self.self.attachIdx >maxVertex then
	  self.self.attachIdx = maxVertex
	end
end
]]
function Attachmesh:Setup(node,component)
	self.Node = node

	self.attachRender = component:GetComponent(4)
	self.attachTransform = component:GetComponent(7)

	if self.Node ~= nil and self.attachRender~= nil and self.attachTransform ~= nil then

		return true
	else
		return false
	end
end

--[[
function Attachmesh:ResetWorldPosition()
	self.wposition = nil
end]]


function Attachmesh:GetTransform()
    if self.transform==nil then
        self.transform = self.Node:GetComponent(apolloengine.Node.CT_TRANSFORM);
        if self.transform==nil then
            LOG("WE HAVE NO TRANSFORM COMPOENENT!")
        end
    end
    return  self.transform;
end

function Attachmesh:GetRender()
    if self.render==nil then
        self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
        if self.render==nil then
            LOG("WE HAVE NO RENDER COMPOENENT!")
        end
    end
    return  self.render;
end

function Attachmesh:SetShow(isshow)
  if self.isshow ~= isshow then
    self.isshow = isshow;
    local render = self:GetRender()
    if isshow then
      render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    else
      render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    end  
  end
end


function Attachmesh:_Play()

end

function Attachmesh:_OnAwake()

end

function Attachmesh:_OnStart()
  
end

function Attachmesh:SetRun(run)
	self.run = run
end

function Attachmesh:running()
	return self.run
end


function Attachmesh:Positioning()
  local transform = self:GetTransform()
  
  if self.wposition == nil then 
	self.wposition = transform:GetWorldPosition()
	self.hasChanged = true
  end

  local attachRender = self:GetAttachrender()

  if attachRender == nil then
    ERROR("NO ATTACH RENDER")
    return false
  end
  if not attachRender:isRenderProperty(apolloengine.RenderComponent.RP_SHOW) then
	ERROR("NOT A RENDER")
    return false
  end
  
  local attachTransform = self:GetAttachtransform()
  
  if attachTransform == nil then
	ERROR("No Attach Transform")
	return false
  end

  local vtxstream = attachRender:GetVertexStream()
  if vtxstream == nil then
    ERROR("fail to get vtxstream")
    return false
  end
  local vtxdata = vtxstream:GetVertexData()
  
  if vtxdata == nil then
    ERROR("fail to get vtxdata")
	return false
  end

  local normals = vtxstream:GetNormalData()
  
  local distance = 100.0
  local lattachIdx = nil
  
  if self.hasChanged == true then
	  attachMeshWorldTransform = attachTransform:GetWorldRotation()
	  attachMeshWorldPosition = attachTransform:GetWorldPosition()

	  
	  --寻找最近的顶点
	  for p = 1,#vtxdata do
	    --将local 转换去world
		local lpos = rotate_vector_by_quaternion( mathfunction.vector4(0,round(vtxdata[p][1],4),round(vtxdata[p][2],4),round(vtxdata[p][3],4)),attachMeshWorldTransform)+mathfunction.vector3(round(attachMeshWorldPosition:x(),4),round(attachMeshWorldPosition:y(),4),round(attachMeshWorldPosition:z(),4))
					
		local dist = ((round(self.wposition:x(),4) - lpos:x())^2+(round(self.wposition:y(),4) -lpos:y())^2+(round(self.wposition:z(),4) -lpos:z())^2)^0.5
		
		if dist<=distance then

			distance = dist
			lattachIdx = p

		end

	  end
	 
	  self.attachIdx = lattachIdx
	  self.hasChanged = false
    end
  

  local position = vtxdata[self.attachIdx]  
  local normal = normals[self.attachIdx]
  local pos = {}
  pos.position = mathfunction.vector3(position[1], position[2], position[3])
  pos.rotation = mathfunction.Quaternion()

  pos.rotation:AxisToAxis(mathfunction.vector3(0, 0, 1), mathfunction.vector3(normal[1], normal[2], normal[3]))
  
  if self.initR == nil then
    self.initR = transform:GetLocalRotation()
  end
  
  pos.rotation = pos.rotation * self.initR
  

  if transform then
    transform:SetLocalPosition(pos.position)
    transform:SetLocalRotation(pos.rotation)
    --transform:SetLocalScale(mathfunction.vector3(100,100,100))
  end
  --LOG("Update attach mesh")
  return true
end



function Attachmesh:_OnUpdate(timespan)
	
  if dragging() == true and self:running() then
	self.wposition = nil
  end
  if self:Positioning() and self:running() then
    self:SetShow(true)
  else
    self:SetShow(false)
	self.wposition = nil
  end
end



function round(num, numDecimalPlaces)
  local mult = 10^(numDecimalPlaces or 0)
  return math.floor(num * mult + 0.5) / mult
end


function rotate_vector_by_quaternion(v,q)
	
	qprime = mathfunction.vector4(q:x(),-1*q:y(),-1*q:z(),-1*q:w()) / ((q:x())^2+(q:y())^2+(q:z())^2+(q:w())^2)^0.5
	
	vprime =  hamilton_product(hamilton_product(q,v),qprime)
	
	return mathfunction.vector3(vprime:y(),vprime:z(),vprime:w())
end



function hamilton_product(v,q)
	s1 = v:x()
	s2 = q:x()
	v1 = mathfunction.vector3(v:y(),v:z(),v:w())
	v2 = mathfunction.vector3(q:y(),q:z(),q:w())
	backside = mathfunction.vector3(s1,s1,s1)*v2+mathfunction.vector3(s2,s2,s2)*v1+v1:Cross(v2)
	return mathfunction.vector4(s1*s2-v1:Dot(v2),backside:x(),backside:y(),backside:z())
end



function abs(x)
	if x<0 then
		x = -1*x
	end
	
	return x
end



function compare(a,b)
  return a[2] < b[2]
end

--检查是否在Scene window里拉
function dragging()
	if ImGui:IsMouseDown(0) then
	  local scenewindowpos = ImGui:GetContentsRegionRectbyName("Scene");
	  local mousepos = ImGui:GetMousePos();
	  local mouseinscene =   mousepos:x() > scenewindowpos:x() and mousepos:y() > scenewindowpos:y() and mousepos:x() < scenewindowpos:z() and mousepos:y() < scenewindowpos:w();
	  if mouseinscene then
		return true
	  else
		return false
	  end
	end

end
--[[
Attachmesh:MemberRegister("attachrender",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.RenderComponent:RTTI(),    
    Attachmesh.GetAttachrender,
    Attachmesh.SetAttachrender
)); 

  
Attachmesh:MemberRegister("attachidx",
  venuscore.ScriptTypes.IntType(
    nil, nil,
    Attachmesh.GetAttachIdx,
	Attachmesh.SetAttachIdx
));
]]



return Attachmesh;