local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"


local ikavatar = {}

local radiusscale = math.pi / 180;
function ikavatar:_CreateJoint(joint, lx, ux, ly, uy, lz, uz)
  self.render:CreateJoint(
    joint,
    mathfunction.vector3(lx * radiusscale, ly * radiusscale, lz * radiusscale),
    mathfunction.vector3(ux * radiusscale, uy * radiusscale, uz * radiusscale));
end


function ikavatar:Initialize(wordpos)

  self.render = apollonode.ModelNode();
  self.render:CreateResource("comm:documents/model/male");
  self.render:SetLocalPosition(wordpos);


  self:_CreateJoint("m_avg_Pelvis", -30, 30, -30, 30, -30, 30, false);
  
  self:_CreateJoint("m_avg_L_Shoulder", -30, 30, -100, 100, -60, 100, false); --arm
  self:_CreateJoint("m_avg_L_Elbow", -30, 30, -150, 0, 0, 0, false); --forcearm  
  self:_CreateJoint("m_avg_L_Wrist", 0, 0, 0, 0, 0, 0, false); --forcearm
  self.render:CreateEffector("m_avg_L_Shoulder");
  self.render:CreateEffector("m_avg_L_Elbow");
  self.render:CreateEffector("m_avg_L_Wrist");  

  self:_CreateJoint("m_avg_R_Shoulder", -30, 30, -100, 100, -100, 60, false); --arm
  self:_CreateJoint("m_avg_R_Elbow", -30, 30, 0, 150, 0, 0, false); --forcearm
  self:_CreateJoint("m_avg_R_Wrist", 0, 0, 0, 0, 0, 0, false); --forcearm
  self.render:CreateEffector("m_avg_R_Shoulder");
  self.render:CreateEffector("m_avg_R_Elbow");
  self.render:CreateEffector("m_avg_R_Wrist");

  self:_CreateJoint("m_avg_L_Hip", -90, 90, -20, 20, -30, 30, false);
  self:_CreateJoint("m_avg_L_Knee", 0, 150, 30, 30, 0, 0, false);
  self:_CreateJoint("m_avg_L_Ankle", 0, 0, 0, 0, 0, 0, false);
  self.render:CreateEffector("m_avg_L_Hip");
  self.render:CreateEffector("m_avg_L_Knee");
  self.render:CreateEffector("m_avg_L_Ankle");  
  
  self:_CreateJoint("m_avg_R_Hip", -90, 90, -20, 20, -30, 30, false);
  self:_CreateJoint("m_avg_R_Knee", 0, 150, 30, 30, 0, 0, false);
  self:_CreateJoint("m_avg_R_Ankle", 0, 0, 0, 0, 0, 0, false);
  self.render:CreateEffector("m_avg_R_Hip");
  self.render:CreateEffector("m_avg_R_Knee");
  self.render:CreateEffector("m_avg_R_Ankle");  

  self.render:SetRootJoint("m_avg_Pelvis");

  self.render:LinkJoints("m_avg_Pelvis", "m_avg_L_Shoulder");
  self.render:LinkJoints("m_avg_L_Shoulder", "m_avg_L_Elbow");
  self.render:LinkJoints("m_avg_L_Elbow", "m_avg_L_Wrist");

  self.render:LinkJoints("m_avg_Pelvis", "m_avg_R_Shoulder");
  self.render:LinkJoints("m_avg_R_Shoulder", "m_avg_R_Elbow");
  self.render:LinkJoints("m_avg_R_Elbow", "m_avg_R_Wrist");

  self.render:LinkJoints("m_avg_Pelvis", "m_avg_L_Hip");
  self.render:LinkJoints("m_avg_L_Hip", "m_avg_L_Knee");
  self.render:LinkJoints("m_avg_L_Knee", "m_avg_L_Ankle");
  
  self.render:LinkJoints("m_avg_Pelvis", "m_avg_R_Hip");
  self.render:LinkJoints("m_avg_R_Hip", "m_avg_R_Knee");
  self.render:LinkJoints("m_avg_R_Knee", "m_avg_R_Ankle");

  self.render:BuildKinematics();
  return true;
end

function ikavatar:Update(targets)
  for name, pos in pairs(targets) do    
    self.render:SetTarget(name, pos);
  end  
  --for i=1, 10 do
    local err = self.render:UpdateKinematics();
  --end  
end

return ikavatar;