local TransNode = require "apolloutility.apollonode.trasnnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

--骨骼与动画节点
local SkeletonNode = TransNode:extend();

function SkeletonNode:new()
    SkeletonNode.super.new(self);
    self.node:SetName("SkeletonNode");
    self.skeleton = self.node:CreateComponent(apolloengine.Node.CT_SKELETON)
    self.animations = nil;
end

function SkeletonNode:SetSkeletonAndAnims(skeletonpath,aniInfo)

    if aniInfo~=nil then
      self.animation = self.node:CreateComponent(apolloengine.Node.CT_ANIMATION)
      self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(aniInfo.hasscale and 0 or 1,0,skeletonpath));
      self.animation:PushMetadata(apolloengine.KeyFrameFileMetaData(aniInfo.hasscale and 0 or 1,1,aniInfo.name));
      self.skeleton:CreateResource();
      self.animation:CreateResource();
        --set default interval
      self.animation:SetAnimationInterval(0,aniInfo.framecount-1);
      self.framecount = aniInfo.framecount;
    else 
      self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(0,0,skeletonpath));
      self.skeleton:CreateResource();
    end
end

function SkeletonNode:SetSkeletonAndAnims2(skeletonpath,aniInfo,hasScale,originalName)
  if aniInfo~=nil then
    self.animation = self.node:CreateComponent(apolloengine.Node.CT_ANIMATION)
    local name = {}
    self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(hasScale and 0 or 1,0,skeletonpath));
    self.skeleton:CreateResource();
    for i = 1, table.getn(aniInfo), 1 do
      self.animation:PushMetadata(apolloengine.KeyFrameFileMetaData(hasScale and 0 or 1,1,aniInfo[i].name));
      self.animation:CreateResource();
      self.animation:SetAnimationInterval(0,aniInfo[i].framecount-1);
    end
 
  --self.skeleton:SetAnimation(originalName);
 
     --set default interval 
  else 
    self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(0,0,skeletonpath));
    self.skeleton:CreateResource();
  end
end

function SkeletonNode:SetRetargetSkeletonAndAnims(skeletonpath,aniInfo,retarget_skeletonpath,retarget_aniInfo)
    self.skeleton:PushMetadata(apolloengine.SkeletonRetargetFileMetadata(aniInfo.hasscale and 0 or 1,skeletonpath,aniInfo.name,
      retarget_aniInfo.hasscale and 0 or 1, retarget_skeletonpath,retarget_aniInfo.name));
    self.skeleton:CreateResource();
    --set default interval
    --self.skeleton:SetAnimationInterval(0,retarget_aniInfo.framecount-1);
    self.framecount = retarget_aniInfo.framecount;
end

function SkeletonNode:CreateResource(skeletonPath,skeletonType,defaultAnimation,animationList)
  self.skeleton:PushMetadata(apolloengine.SkeletonFileMetaData(skeletonType,0,skeletonPath));
  local animationListCnt = #animationList;
  if animationListCnt>= 1 then
    self.animation = self.node:CreateComponent(apolloengine.Node.CT_ANIMATION)
  end
  for i = 1, animationListCnt, 1 do
    local animationInfo = animationList[i];
    self.animation:PushMetadata(apolloengine.KeyFrameFileMetaData(skeletonType,1,animationInfo[1]));
    self.animation:SetAnimationInterval(0,animationInfo[2] - 1);
  end
  self.skeleton:CreateResource();
  if animationListCnt>= 1 then
    self.animation:CreateResource();
  end
  if animationListCnt > 0 then
    self.animation:SetDefaultAnimation(animationList[1][1]); --设置默认动画
  end
  
end



function SkeletonNode:UpdateAnimation(def)
  self.animation:Update(def);
  return self.animation:GetAnimationStatus();
end

--test retarget
function SkeletonNode:GetSkeletonComponent()
  return self.skeleton;
end

function SkeletonNode:AddRetarget(target)
  self.skeleton:AddRetargetComponent(target:GetSkeletonComponent());
end

function SkeletonNode:SetLoop(loop)
    self.animation:Loop(loop);
end

function SkeletonNode:Reset(frame)
if frame then
    self.animation:Reset(frame)
else
    self.animation:Reset()
end  
end

function SkeletonNode:Play()
    self.animation:Play()
end

function SkeletonNode:Stop()
    self.animation:Stop()
end

function SkeletonNode:SetAnimationInterval(from,to)
    if from < 0 then
        from = 0;
    end

    if self.framecount and to > self.framecount-1 then
        to = self.framecount-1;
    end
    self.animation:SetAnimationInterval(from,to);
end

function SkeletonNode:GetFrameCount()
    return self.framecount;
end

function SkeletonNode:AttachNodeToJoint(jointName,node)
    self.skeleton:AttachNodeToJoint(jointName,node);
end

local function _TransNodeCast(rawnode)
  local transnode = {}
  transnode = TransNode:cast(transnode);
  transnode.node = rawnode;
  transnode.position = mathfunction.vector3();
  transnode.trans = rawnode:GetComponent(apolloengine.Node.CT_TRANSFORM);
  return transnode;
end

function SkeletonNode:GetJoint(name)
    local rawnode = self.skeleton:GetJoint(name);
    if rawnode then
      return _TransNodeCast(rawnode);
    end
    ERROR("unkown joint with name '"..name.."'");
    return nil;      
end

function SkeletonNode:GetJointNames()
    return self.skeleton:GetJointNames();
end

function SkeletonNode:GetBoneRoots()
  return self.skeleton:GetBoneRoots();
end

function SkeletonNode:_CreateKinematicsComponent()
  if not self.ik then
    self.ik = self.node:CreateComponent(apolloengine.Node.CT_KINEMATICS);
  end  
end

function SkeletonNode:CreateJoint(name, rotlimlow, rotlimup)
  self:_CreateKinematicsComponent();
  return self.ik:CreateJoint(name, rotlimlow, rotlimup);
end

function SkeletonNode:SetTarget(name, t)
  return self.ik:SetTarget(name, t);
end

function SkeletonNode:CreateEffector(name)
  return self.ik:CreateEffector(name);
end

function SkeletonNode:SetRootJoint(name)
  return self.ik:SetRootJoint(name);
end

function SkeletonNode:LinkJoints(j1, j2)
  return self.ik:LinkJoints(j1, j2);
end

function SkeletonNode:BuildKinematics()
  self.ik:BuildKinematics();
end

function SkeletonNode:UpdateKinematics()
  return self.ik:UpdateKinematics();
end

return SkeletonNode;