#include "functions/util.function"
#SHADER_DEFINE ComicVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;  
    vec2 out_TexCooridate;
    out_TexCooridate= in_TexCoordinate.xy;     // upper left corner
 
#END_CODE

#END_DEFINE


#SHADER_DEFINE ComicFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_Lab,		    	NONE,	TEXTURE2D,	  "Lab" },
		{ TEXTURE_uLut,		    	NONE,	TEXTURE2D,	  "uLut" },
		{ TEXTURE_Outline,		    	NONE,	TEXTURE2D,	  "Outline" },
        { ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,	"vUV"},
        { UNIFORM_uS,             	MEDIUM, FLOAT,   "uS"},
        { UNIFORM_uLop,             MEDIUM, FLOAT,   "uLop"},
        { UNIFORM_uOin,            	MEDIUM, FLOAT,   "uOin"},
		{ UNIFORM_uSaturantion,     MEDIUM, FLOAT,   "uSat"},
	}
  
#SHADER_CODE

	vec3 c = texture2D(Lab, vUV).rgb;
    int currentLevel = getLevel(c.r,uLop);
    c.r = applyLevel(currentLevel,uLop);
	
    c = lab2rgb(c) * texture2D(Outline, vUV).r;
    c = clamp(c, 0., 1.);
	
	//gl_FragColor.rgb = (gl_FragColor.rgb - vec3(0.5)) * 1.2 + vec3(0.5);
	
	//vec3 hsv = rgb2hsv(c.rgb);
	//hsv.g = pow(hsv.g, uSat);
	//c.rgb = hsv2rgb(hsv);
	
	//if (abs(uOin) < 0.0001) 
	c = lut(c,uLut);
    //else c = lut(c.bgr,uLut).bgr;
	
	//c = lut(c.bgr,uLut).bgr;
	//c = LUT(vec4(c.bgr,1.0),uLut).bgr;
	
    gl_FragColor = vec4( abs(uS - 1.0) < 0.0001 ? c.ggg : c, 1.0);

#END_CODE

#END_DEFINE