
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
UNIFORM_CENTER = { "Center", VEC2, "0.0,0.0"},
UNIFORM_SCALE = { "Scale", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "Dolly"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 UNIFORM_CENTER;
float UNIFORM_SCALE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	float2 positionToUse  = float2(v.uv.x * 2.0 - 1.0, v.uv.y * 2.0 - 1.0);
    positionToUse = (positionToUse - UNIFORM_CENTER)/(1.0+UNIFORM_SCALE)+UNIFORM_CENTER;
    o.uv = float2(positionToUse.x *0.5 + 0.5,positionToUse.y *0.5+0.5);
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float3 rgb = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv).rgb;
    mainColor = float4(rgb, 1.0);
}
ENDCG
#END
