local basetype = require "venuscore.rtti.types.basetype"


local ArrayType = basetype:extend("ArrayType");--这个名字不能改，影响序列化


function ArrayType:new(funcCreateDefaultItem, get, set,getByIndex, setByIndex)
  ArrayType.super.new(self, get, set);
  self.funcCreateDefaultItem = funcCreateDefaultItem;
end

function ArrayType:SetKeyname(keyname)
  if not self.getByIndex then
    self.getByIndex = function(currentobj,index)
      return currentobj[keyname][index];
    end    
  end  
  if not self.setByIndex then
    self.setByIndex = function(currentobj, index,value)
      currentobj[keyname][index] = value;
    end    
  end  
  ArrayType.super.SetKeyname(self,keyname);
end

function ArrayType:GetDefaultItem(owner)
  return self.funcCreateDefaultItem(owner);
end

function ArrayType:GetArrayItem(obj,index)
  return self.getByIndex(obj,index);
end

function ArrayType:SetArrayItem(obj,index,value)
  self.setByIndex(obj,index,value)
end

return ArrayType;