local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local RunStateMachineCommand = CommandBase:extend("RunStateMachineCommand");

function RunStateMachineCommand:new(uuid)
  RunStateMachineCommand.super.new(self);
    self._uuid = uuid;
end

function RunStateMachineCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani then
        ani:RunStateMachines();
      end
    end
    self:EndCmd();
end

function RunStateMachineCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return RunStateMachineCommand;