local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local DeleteConditionCommand = CommandBase:extend("DeleteConditionCommand");

function DeleteConditionCommand:new(uuid, smsId, transitionId, deleteInd)
    DeleteConditionCommand.super.new(self);
    self._smsId = smsId;
    self._uuid = uuid;
    self._deleteId = deleteInd;
    self._transitionId = transitionId;
end

function DeleteConditionCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani and self._deleteId ~= nil then
        local tran = ani:GetTransitionById(self._smsId, self._transitionId);
        if tran then
            tran:RemoveCondition(self._deleteId);
        end
      end
    end
    self:EndCmd();
end

function DeleteConditionCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return DeleteConditionCommand;