local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local CreateTransitionCommand = CommandBase:extend("CreateTransitionCommand");

function CreateTransitionCommand:new(uuid, src_stateId, dst_stateId)
    CreateTransitionCommand.super.new(self);
    self._uuid = uuid;
    self._srcId = src_stateId;
    self._dstId = dst_stateId;
    self._transitionUUID = ContentManager:GenerateUUID();
    self._transition = nil;
end

function CreateTransitionCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani then
        local src_state = ani:GetStateById(0, self._srcId);
        local dst_state = ani:GetStateById(0, self._dstId);
        if src_state and dst_state then
                self._transition = ani:CreateTransition(0, src_state, dst_state);
                self._transition:SetStaticID(self._transitionUUID);
        end
      end
    end
    self:EndCmd();
end

function CreateTransitionCommand:Undo()
    self:BeginCmd();
    if self._transition then
      local ani = self:GetContent(self._uuid);
      ani:RemoveTransition(0, self._transition);
    end
    self:EndCmd();
end

return CreateTransitionCommand;