


local MEncoder = require "venuscore.bundle.mserializer.mencoder"
local Object = require "venuscore.rtti.object"



--内存序列化
local MSerializer = Object:extend("MSerializer");

function MSerializer:new()
  MSerializer.super.new(self,"MemorySerializer");
  self.memEncoderArray = {};
  self.encoderIndex = 0;
  self.encodeFinished = false;
  self.version = nil;
end


function MSerializer:GetEncoder()
  local encoder = nil;
  if #self.memEncoderArray > self.encoderIndex then
    encoder = self.memEncoderArray[self.encoderIndex];
  else
    encoder = MEncoder(self);
    table.insert(self.memEncoderArray,encoder);
  end
  self.encoderIndex = self.encoderIndex + 1;
  return encoder;
end



function MSerializer:GetVersion()
  return self.version;
end

function MSerializer:GetBuffer()
  local resTable = {};
  if self.encodeFinished == false then
    self.encodedFinished = true;
    if self.encoderIndex > 0 then
      local memberList = self.memEncoderArray[1]:GetMemberList();
      table.insert(resTable,memberList);
    end
  end
  return resTable;
end


return MSerializer;