
local Object = require "classic"

local oneeurofilter = Object:extend();

function oneeurofilter:smoothing_factor(t_e, cutoff)
    local r = 2 * math.pi * cutoff * t_e
    return r / (r + 1);
end

function oneeurofilter:exponential_smoothing(a, x, x_prev)
    return a * x + (1 - a) * x_prev
end


function oneeurofilter:new(t0, x0, dx0, min_cutoff, beta,
    d_cutoff)
    if dx0 == nil then
        dx0 = 0;
    end
    if min_cutoff == nil then
        min_cutoff = 1;
    end
    if beta == nil then
        beta = 0;
    end
    if d_cutoff == nil then
        d_cutoff = 1
    end
    --The parameters.
    self.min_cutoff = min_cutoff;
    self.beta = beta;
    self.d_cutoff = d_cutoff;
    --Previous values.
    self.x_prev = x0;
    self.dx_prev = dx0;
    self.t_prev = t0;
end

function oneeurofilter:filter(t, x)
    --Compute the filtered signal.
    local t_e = t - self.t_prev
    if t_e <= 0.000001 then
      return self.x_prev;
    end
    --The filtered derivative of the signal.
    local a_d = self:smoothing_factor(t_e, self.d_cutoff)
    local  dx = (x - self.x_prev) / t_e
    local dx_hat = self:exponential_smoothing(a_d, dx, self.dx_prev)

    --The filtered signal.
    local cutoff = self.min_cutoff + self.beta * math.abs(dx_hat)
    local a = self:smoothing_factor(t_e, cutoff)
    local x_hat = self:exponential_smoothing(a, x, self.x_prev)

    --Memorize the previous values.
    self.x_prev = x_hat
    self.dx_prev = dx_hat
    self.t_prev = t

    return x_hat
end

return oneeurofilter;