local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local siximg = {}
siximg.material = nil;
siximg.renderobject = nil;
siximg.Queue = 201;



function siximg:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.RATIOASPECT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"RATIOASPECT");
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/siximg.material" );
  self.material:SetParameter(self.RATIOASPECT, mathfunction.vector1(size:y()/size:x()) );
  
  return self.Queue;
end

function siximg:Resizeview(size)
  --self:_SetParam(size);
end

function siximg:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return siximg;