local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local apollodefine = require "apolloengine.defined"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local SetParameterNode = BlueNode:extend();

--SetParameterNode的材质输入引脚为BlueSelf() 也就是只允许连线输入 或者在materialEntity挂蓝图

---- 游戏运行模式
function SetParameterNode:new(...)
  SetParameterNode.super.new(self, ...)
end

function SetParameterNode:GetParameterType(args)
  

  local materialEntity = args[1];
  if not materialEntity then --输入为空 没有连线编译时就会报错
    self.errorWarning = "there is no MaterialEntity";
    return;
  end

  local slotname = args[2];

  local _Slot = apolloengine.IMaterialSystem:GetParameterSlot(slotname);
  if args[1]:HasDefProperty(_Slot)  then
    local _DefProperty = args[1]:GetDefProperty(_Slot);
    local parseType = _DefProperty:GetParserType();
    return parseType;
  else
    self.errorWarning = tostring("there isnt parameter named "..slotname);
    return;       
  end

end


function SetParameterNode:SetParameter(args, paraType, rightType)
  --require "venusdebug"
  --_COROUTINES_ON();
  if not paraType then 
    return;
  end
  if paraType == rightType then
    args[1]:SetParameter(args[2], args[3]);
    --这个只是针对这个shader才做的处理，只有这种材质，当这个蓝图节点"设置纹理"调用的时候，才要设置这个参数。
    --新的编辑器有前景prefab, 用这个shader, 配合StickerQuadBehaviour脚本(里面会每次update检测textureentity的宽高比来更新材质参数)使用，就可以不用这段判断和设置，
    --但如果不配合这个脚本，就要配合这段代码
    if rightType == apolloengine.MaterialEntity.VT_TEXTURE2D
      and args[1]:GetShaderPath() == apollodefine.htStickerShader then
        local entity = args[3];
        local imgSize;
        if entity:isTypeOrDriverType(apolloengine.TextureEntity:RTTI()) then
          imgSize = entity:GetSize();
        elseif entity:isTypeOrDriverType(apolloengine.RenderTargetEntity:RTTI()) then
          entity = entity:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
          imgSize = entity:GetSize();
          LOG("--fboSize is---"..tostring(imgSize));
        end
        local aspectRatio = mathfunction.vector1(imgSize.mx/imgSize.my);
        args[1]:SetParameter("_TexAspect", aspectRatio);
    end
  else
    self.errorWarning = "parameter type not matched!";
  end
  --_COROUTINES_OFF();
end

---- 编辑器模式


return SetParameterNode ;

