local BlueFunctionNode = require "bluecore.functioncore.blue_func_node"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"

local FunctionInputNode = BlueFunctionNode:extend(); 

---- 游戏运行模式
function FunctionInputNode:new(...) --这里的graph一定是bluefunction
  FunctionInputNode.super.new(self, ...)

  -- 保留原来有的输出和输入执行引脚信息(可以为nil)
  local originExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]
  
  self.infoTable = {} -- 重新定义infoTable 元表的infoTable不变
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = {}
  self.infoTable[BD.PIN_EXEC_INPUT]  = {}
  self.infoTable[BD.PIN_EXEC_OUTPUT] = originExecOutputsInfo

  -- 把原来的注册的数据引脚生成为动态的数据引脚

end

function FunctionInputNode:_OnCreateWithEditor()
  self.graph:AddRefactor(self);
end

function FunctionInputNode:_OnInfoChange(reflectIdx, type, val, isInput)
  if not isInput then
    return ;
  end

  local curInfo = self.infoTable[BD.PIN_DATA_OUTPUT][reflectIdx]

  if type == BD.FuncInfoProp.Name then
    curInfo.name = val;
  elseif type == BD.FuncInfoProp.BaseType then
    curInfo:ChangeRtti(val, nil); -- output pin, default is nil
  end
end

function FunctionInputNode:_OnEditorPinDelete(isInput, idx)

  if not isInput then return end ;

  local toDelInsPin = self.outputs[idx];
  self.graph:DeleteNodePin(toDelInsPin.uid);
  self:RemoveOutput(idx);

end


function FunctionInputNode:_OnEditorPinAdd(isInput, reflectInfo)

  if not isInput then return end ;

  local toAddInsPin = self:AddOutput(reflectInfo);
  self.graph.bluePrintAllList[toAddInsPin.uid] = toAddInsPin;

end


function FunctionInputNode:_OnUpdate(args) --bluefunction的函数传参数进来
  return args;
end

function FunctionInputNode:_OnDeserializePost()

  FunctionInputNode.super:_OnDeserializePost()

  --反序列化会调用new函数 不用重新声明infotable
  local newArgId = 1
  local reflectInputsInfo = self.graph:GetInputInfo();
  for key, reflectInfo in pairs(reflectInputsInfo) do
    self:DynamicRegisterOutput(newArgId, reflectInfo:GetRtti(), reflectInfo.name, reflectInfo.tips);
    newArgId = newArgId + 1;
  end

  self.graph:AddRefactor(self); -- self.graph is BlueFunction

end

-- not allow to copy
function FunctionInputNode:IsAllowDuplicate()
  return false;
end

-- not allow to delete
function FunctionInputNode:IsAllowDelete()
  return false;
end

function FunctionInputNode:ToBeDeletedEd()
  -- 所在函数要被删除(编辑器)
end

function FunctionInputNode:NameChanged(oldName, newName)

end

FunctionInputNode:RegisterExecOutput(1, "exec", "Execute");
FunctionInputNode:SetFunctionType(BD.FUNCTION_INTERFACE_NODE);
FunctionInputNode:SetFunctionName("Input");

return FunctionInputNode ;

