local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local BR = require "bluecore.core.blue_rtti"
local Types = require "venuscore.rtti.types"
local BlueprintSelf = require "bluecore.core.blueprint_self"
local BlueNode = require "bluecore.bluenode"
local BluePinInfo = require "bluecore.bluepininfo"
local BindEventDispatcher = BlueNode:extend();

-- 要绑定的自定义事件节点 一定是 跟 绑定事件分派器节点 在同一个蓝图中

BindEventDispatcher:MemberRegister("_clsId");
BindEventDispatcher:MemberRegister("_dispId");
BindEventDispatcher:MemberRegister("nodeName");


function BindEventDispatcher:new(graph)

  BindEventDispatcher.super.new(self, graph)

  self._inputInfoArray = {}  -- 简化版本的 arg_info

end


function BindEventDispatcher:_OnBeginCreateEd(clsUid, dispatchId)
  self._clsId = clsUid;
  self._dispId = dispatchId ;
  self:_Setup(self._clsId,  self._dispId)
end

function BindEventDispatcher:DynamicRegisterInput(argId, rtti, name, tips, default, delAble, groupName)

  if tips == nil then tips = "["..tostring(argId).."]" end
  if name == nil then name = "["..tostring(argId).."]" end

  local info = BluePinInfo(BD.PIN_DATA_INPUT, argId, rtti, name, tips, default, delAble, groupName);
  self.infoTable[BD.PIN_DATA_INPUT][argId] = info

  return info ;

end

-- 蓝图类相关的 比如 函数调用/事件分发器调用/绑定/取消绑定/取消所有绑定 都是在 _OnDeserializePost 阶段才完成引脚的重建
-- 特化的蓝图节点 是不依赖其他节点的
function BindEventDispatcher:_OnDeserializePost()
  self:_Setup(self._clsId,  self._dispId)
end

function BindEventDispatcher:_Setup(clsUid, dispatchId)

  local originExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  local originExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]

  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}  -- 1: Types.BlueprintType 2: Types.EventDelegateType
  self.infoTable[BD.PIN_DATA_OUTPUT] = {} -- no
  self.infoTable[BD.PIN_EXEC_INPUT]  = originExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = originExecOutputsInfo

  local blueType
  local delegateType
  if _KRATOSEDITOR then
    local clsInfo = BR.GetClassesByIdEd(clsUid);

    local dispatcher
    if clsInfo ~= nil then
      blueType = BR.GetRttiByClsId(clsUid);

      local dispatchers = clsInfo:GetEventDispatchers()
      dispatcher = dispatchers[dispatchId]

      if dispatcher ~= nil then
        self:SetFunctionName("Bind Event "..dispatcher:GetName())

        local inputInfo = dispatcher:GetInputInfo();
        delegateType = self:_SetupDelegateType(inputInfo);
      else
        self._failReason = "Dispatcher is deleted"
      end
    else
      self._failReason = "Class is deleted"
    end

    if blueType == nil then
      blueType = Types.BlueprintType.INVALID_BLUEPRINT_TYPE
    end

    if dispatcher == nil then
      self:SetFunctionName("Bind Event n/a")
      delegateType = self:_SetupDelegateType({}); -- 已经被删除 直接用空签名
    else
      dispatcher:AddRefactor(self);
    end
  else
    self:SetFunctionName("UnBind Event default")
    blueType = BR.GetRttiByClsId(clsUid);
    delegateType = Types.EventDelegateType.DEFAULT_DELEGATE_TYPE
  end

  local label = "Target"
  self:DynamicRegisterInput(1, blueType, label, label, BlueprintSelf());
  label = "Event"
  self:DynamicRegisterInput(2, delegateType, label, label);

end

function BindEventDispatcher:_SetupDelegateType(_inputInfoArray)
  local newType = Types.EventDelegateType:extend()
  newType:SetArgsInfo(_inputInfoArray)
  return newType
end

function BindEventDispatcher:EditorPinAdd( )

end

function BindEventDispatcher:EditorPinDelete( )

end

function BindEventDispatcher:InfoChange( )

end

function BindEventDispatcher:ToBeDeletedEd()

  local classInfo = BR.GetClassesByIdEd(self._clsId);
  local dispatchers = classInfo:GetEventDispatchers()
  local dispatcherInfo = dispatchers[self._dispId]
  local name = dispatcherInfo:GetName()
  self._failReason = "dispatcher  "..tostring(name).." is deleted"
  -- 蓝图上没有移除节点
end

function BindEventDispatcher:NameChanged(oldName, newName)
  self:SetFunctionName("Bind Event "..newName)
end

function BindEventDispatcher:_OnDeleteEd()
  local classInfo = BR.GetClassesByIdEd(self._clsId);
  if classInfo ~= nil then
    local dispatchers = classInfo:GetEventDispatchers()
    local dispatcherInfo = dispatchers[self._dispId]
    if dispatcherInfo ~= nil then
      dispatcherInfo:RemoveRefactor(self) -- 移除引用(从蓝图中删除蓝图节点)
    else
      WARNING(string.format("Dispatcher deleted before %s %s", tostring(self._clsId), tostring(self._dispId)))
    end
  else
    WARNING(string.format("Class deleted before %s %s", tostring(self._clsId), tostring(self._dispId)))
  end

end

function BindEventDispatcher:IsAllowDuplicate()
  return false;
end

function BindEventDispatcher:_OnCompile()
  if self._failReason then
    self.compileResult = self._failReason
    return false
  end
  return true
end

function BindEventDispatcher:_OnUpdateByEditor()
  if self._failReason then
    self.compileResult = self._failReason
  end
end

-- override BlueNode's _GetInput
function BindEventDispatcher:_GetInput()
  self.inputArgs = {}

  local arg1Input = self.dependInputs[1];
  arg1Input[1]:Update();
  self.inputArgs[1] = arg1Input[1]:GetOutputByIndex(arg1Input[2]);

  local arg2Input = self.dependInputs[2];
  local customEventNode = arg2Input[1] -- 不需要update 直接用自定义事件节点(实例)
  self.inputArgs[2] = customEventNode

  return self.inputArgs
end

function BindEventDispatcher:_OnUpdate(args)
  local variation = args[1]
  local customEventNode = args[2]
  if variation.GetTypeName then
    local blueprint = variation
    local dispatcher = blueprint:GetEventDispatcherByUid(self._dispId)
    dispatcher:AddDelegate(customEventNode);
  else
    for _, blueprint in pairs(variation) do
      local dispatcher = blueprint:GetEventDispatcherByUid(self._dispId)
      dispatcher:AddDelegate(customEventNode);
    end
  end
end

-- override
function BindEventDispatcher:IsInputArrayCompatible(pinInfo)
  if pinInfo.argId == 1 and pinInfo.pinType == BD.PIN_DATA_INPUT then
    return true -- 第一个数据引脚是BlueprintType
  end
  return false
end

function BindEventDispatcher:ClsIdChgEd(oldClassId, newClassId)

  if oldClassId ==  self._clsId then

    local classInfo = BR.GetClassesByIdEd(self._clsId);
    local dispatchers = classInfo:GetEventDispatchers()
    local dispatcherInfo = dispatchers[self._dispId]
    dispatcherInfo:RemoveRefactor(self)

    self._clsId =  newClassId
    local blueType = BR.GetRttiByClsId(self._clsId);
    local bluePinInfo = self.infoTable[BD.PIN_DATA_INPUT][1]
    bluePinInfo:ChangeRtti(blueType, BlueprintSelf())
  end
end

BindEventDispatcher:RegisterExecInput(1, "exec", "Execute");
BindEventDispatcher:RegisterExecOutput(1, "exec", "Execute");
BindEventDispatcher:SetFunctionName("Bind Event Dispatcher");
BindEventDispatcher:SetFunctionType(BD.EVENT_DISPATCH_NODE);


return BindEventDispatcher
