local mf = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local FromPoint2Point = BlueNode:extend();
local BD = require "bluecore.bluedefined"

---- 两点之间直线取点;
function FromPoint2Point:new(...)
  FromPoint2Point.super.new(self, ...)
  self.isReset = false;
  self.time = 0.0;
end

function FromPoint2Point:_OnUpdate(args)
  local output = mf.vector2(0.0, 0.0);
  local isEnd = false;
  local startPoint = args[1];
  local endPoint = args[2];
  local maxTime = args[3];
  self.isReset = args[4];
  self.time = self.time + self.graph.deltaTime;
  output.mx = startPoint.mx + (endPoint.mx - startPoint.mx)*math.min(self.time/maxTime, 1.0);
  output.my = startPoint.my + (endPoint.my - startPoint.my)*math.min(self.time/maxTime, 1.0);
  if self.time >= maxTime  then
    self.time = 0.0;
    isEnd = true;
  end
  return output, isEnd;
end

function FromPoint2Point:_OnReset()
  if self.isReset then
    self.time = 0.0;
    self.isMoving = false;
    self.isReset = false;
  end
end

---- 编辑器模式
FromPoint2Point:RegisterInput(1, mf.vector2():RTTI(), "start", "起始点", mf.vector2(0.5,0.5));
FromPoint2Point:RegisterInput(2, mf.vector2():RTTI(), "end", "结束点", mf.vector2(0.5,0.5));
FromPoint2Point:RegisterInput(3, Types.FloatType, "seconds", "时间", 1.0);
FromPoint2Point:RegisterInput(4, Types.BoolType, "isReset?", "蓝图重置节点是否影响该节点？", false);
FromPoint2Point:RegisterOutput(1, mf.vector2():RTTI(), "output", "当前计算点");
FromPoint2Point:RegisterOutput(2, Types.BoolType, "isEnd?", "当前移动是否到达终点");
FromPoint2Point:RegisterExecInput(1, "exec", "执行");
FromPoint2Point:RegisterExecOutput(1, "exec", "执行");
FromPoint2Point:SetFunctionName("x1y1->x2y2");

return FromPoint2Point;

