local BlueDefined = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"


local Equal = BlueNode:extend();

---- 游戏运行模式
function Equal:new(...)
  Equal.super.new(self, ...)
  self.result = false ;
end

function Equal:_OnUpdate(args)
  if math.abs(args[1]-args[2]) < 0.00001 then
    self.result = true
  else
    self.result = false
  end 
  return self.result;
end

---- 编辑器模式
Equal:RegisterInput(1, Types.FloatType, "1", "[1]", 0);
Equal:RegisterInput(2, Types.FloatType, "2", "[2]", 0);

Equal:RegisterOutput(1, Types.BoolType, "==", "对比结果");

Equal:SetFunctionName("==");
Equal:SetFunctionType(BlueDefined.STATIC_FUNCTION_NODE);

return Equal ;

