


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local BlueDefined = require "bluecore.bluedefined"
local BlueUtility = require "bluecore.blueutility"

local CreateTexCube = BlueNode:extend();


---- 游戏运行模式
function CreateTexCube:new(...)

  CreateTexCube.super.new(self, ...)

end


function CreateTexCube:_OnUpdate(args)

  --需要给一个hdr素材~
  if args[1] == "None" then
    self.errorWarning = "nil path";
    return;
  end
  local entity = BlueUtility:CreateEntity(args[1], "hdr");	

  return entity;

end

---- 编辑器模式
CreateTexCube:RegisterInput(1, Types.TexCubePathType, "TexCube Path", "根据纹理路径创建纹理", "None");

CreateTexCube:RegisterOutput(1, apolloengine.TextureEntity:RTTI(), "Tex", "输出纹理");

CreateTexCube:RegisterExecInput(1, "exec", "执行");

CreateTexCube:RegisterExecOutput(1, "exec", "执行");

CreateTexCube:SetFunctionName("CreateTexCube");


return CreateTexCube ;

