local AE = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local BU = require "bluecore.blueutility"

local ResetAllContent = BlueNode:extend();

function ResetAllContent:new(...)
  ResetAllContent.super.new(self,...);
end

function ResetAllContent:_OnUpdate(args)
  self:_RecursiveResetNode(args[1]);
end

function ResetAllContent:_RecursiveResetNode(rootNode)
  --FIXME(hjh) 目前仅支持FrameAni Ani的Reset  在蓝图Reset中把node和component的active状态设置回去
  local AniCom = rootNode:GetComponent(AE.Node.CT_ANIMATION);
  --重置到动画曲线的开头 并停下来
  if AniCom then
    AniCom:ResetAll(true);
    AniCom:Stop();
  end
  local FrameAniCom = rootNode:GetComponent(AE.Node.CT_FRAME_PLAYER);
  if FrameAniCom then
    FrameAniCom:Reset();
    FrameAniCom:Stop();
  end
  local BlueCom = rootNode:GetComponent(AE.Node.CT_BLUEPRINT);
  local ins = BlueCom and BU.GetIns(BlueCom)
  if ins then
    ins:Reset();
  end
  for _,comp in pairs(rootNode.Components) do
    if comp.ResetCached then
      comp:ResetCached();
    end
  end
  local AIMorphCom = rootNode:GetComponent(AE.Node.CT_CV_AIMorph);
  if AIMorphCom then
    AIMorphCom:Reset();
  end
  local childNode = rootNode:GetChildrens();
  for i = 1, #childNode do
    self:_RecursiveResetNode(childNode[i]);
  end
end

ResetAllContent:RegisterInput(1, AE.Node:RTTI(), "target", "递归遍历子节点重置信息(曲线动画/序列帧回到开头并停止)", BlueSelf());

ResetAllContent:RegisterExecInput(1, "exec", "Execute");

ResetAllContent:RegisterExecOutput(1, "exec", "Execute");

ResetAllContent:SetFunctionName("Reset All Content New");

return ResetAllContent;

