local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"

local OnRecordStart = BlueNode:extend();

function OnRecordStart:new(...)
  OnRecordStart.super.new(self, ...)
end

function OnRecordStart:_OnUpdate(eventParam)

end

function OnRecordStart:RegisterTriggerFunc(func, bluePrintSelf)
  EventDispatcher:RegisterCallback(BlueDefined.Event.RecordComponent, BlueDefined.Event.RecordEvent.Start, func, bluePrintSelf);
end


--OnRecordStart节点只允许一个存在
function OnRecordStart:IsAllowDuplicate()
    return false;
end


OnRecordStart:RegisterExecOutput(1, "OnTrigger", "执行");

OnRecordStart:SetFunctionName("_OnRecordStart");

OnRecordStart:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnRecordStart:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnRecordStart;

