local venuscore = require "libvenuscore"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BlueSelf = require "bluecore.blueself"
local EventDispatcher = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"
local CV = require "computervisionfunction"
local BU = require "bluecore.blueutility"
local CatExists = BlueNode:extend();

local BREAK = 0
local TRIGGER = 1
local RELEASE = 2


---- 游戏运行模式
function CatExists:new(...)
  CatExists.super.new(self, ...)
  self:_OnReset();
  self.faceID = 1
end

function CatExists:_OnUpdate(formatFaceArray)
  -- 有人的时候onUpdate
  -- print("FaceExists:_OnUpdate")
  -- {1}
  self._formatOutputArray = formatFaceArray

  self.nextExecIdx = BREAK
  local detected = false

  if self._formatOutputArray ~= nil  then
    for _, id in pairs(self._formatOutputArray) do
      if id == self.faceID then
        detected = true
      end
    end
  end

  if detected then

    local edge = false
    if self.lastDetect == false then
      self.lastDetect = true
      edge = true
    end

    if self.isEdge and edge then
      self.nextExecIdx = TRIGGER
    elseif not self.isEdge then
      self.nextExecIdx = TRIGGER
    end

  else

    if self.lastDetect then
      self.lastDetect = false
      self.nextExecIdx = RELEASE
    end

  end

  return detected;
end

function CatExists:_OnReset()
  self._formatOutputArray = {}
  self.lastDetect = false
  self.nextExecIdx = BREAK
end

function CatExists:_OnNextBranch()
  return self.nextExecIdx
end


function CatExists:RegisterTriggerFunc(func, bluePrintSelf)

  self:_GetInput()

  EventDispatcher:RegisterCallback(
          self.inputArgs[1]:GetContentPath(),
          BD.Event.VirtualEvent.HasCat,
          func,
          bluePrintSelf)

  -- 调用blueprint reset会导致所有node的inputArgs清空
  self.faceID = self.inputArgs[2]
  if self.faceID <= 0 then
    self.faceID = 1
  end

  self.isEdge = self.inputArgs[3] or false

end


function CatExists:_OnCompile()
  self.compileResult = nil
  if CatExists.super._OnCompile(self) then
    -- Step.1 确保Component引脚有连接
    if #self.inputs[1].links ~= 0 then
      local bluePinLink = self.inputs[1].links[1] -- 输入引脚只允许一个连接
      local otherNode = self.graph:GetNode(bluePinLink.nodeUid);

      -- Step.2 确保上一个节点是 引用组件类型 的节点
      if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp == nil then
        self.compileResult = BD.EHINT.NOT_LINK_TO_COMP
        return false
      end

      if venuscore.isNil(otherNode.comp) then
        self.compileResult = BD.EHINT.COMP_LOST
        return false
      end

      -- Step.3 CatFaceComponent没有激活当前的检测类型
      local hasType = self:_HasType(otherNode.comp);
      if not hasType then
        self.compileResult = BD.EHINT.NOT_ENABLE;
        return false
      end
    else
      self.compileResult = BD.EHINT.PIN_1_EMPTY;
      return false
    end
    return true ;
  end
  return false;
end
--  bad argument #2 to 'band' (number expected, got nil)
function CatExists:_HasType(comp)
  return bit.band(comp.Type, CV.CatFaceComponent.cvCatface) ~= 0
end

function CatExists:_OnDeserialize()
  CatExists.super._OnDeserialize(self);
end

---- 编辑器模式
if _KRATOSEDITOR then

function CatExists:_OnLink(selfPin, otherNode, otherPin)
  if BU:IsInputPin(selfPin) and selfPin.argId == 1 then
    if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp then
      if venuscore.isNil(otherNode.comp) then
        ERROR(BD.EHINT.COMP_LOST)
      else
        local hasType = self:_HasType(otherNode.comp);
        if not hasType then
          ERROR(BD.EHINT.NOT_ENABLE)
        end
      end
    else
      ERROR(BD.EHINT.NOT_LINK_TO_COMP)
    end
  end
end

function CatExists:_OnUnLink(unlinkPin)
  if unlinkPin.argId == 1 then
     ERROR(BD.EHINT.PIN_1_EMPTY)
  end
end

function CatExists:_OnCreateWithEditor()
  CatExists.super._OnCreateWithEditor(self);
end

function CatExists:_OnUpdateByEditor()
  CatExists.super._OnUpdateByEditor(self);
  self:_OnCompile();
end

end

CatExists:RegisterInput(1, CV.CatFaceComponent:RTTI(), "component", "监听组件", BlueSelf());
CatExists:RegisterInput(2, Types.IntType, "index", "face index(从1开始)", 1);
CatExists:RegisterInput(3, Types.BoolType, "isEdge", "从无到有触发一次(OnTrigger)", false);

CatExists:RegisterOutput(1, Types.BoolType, "hasCat", "有猫脸?");

CatExists:RegisterExecOutput(TRIGGER, "OnTrigger", "execute");
CatExists:RegisterExecOutput(RELEASE, "OnRelease", "execute");

CatExists:SetFunctionName("Has CatFace?");
CatExists:SetFunctionType(BD.EVENT_FUNCTION_NODE);
CatExists:SetEventType(BD.EventType.RegisterCallback);

return CatExists;
