local AE = require "apolloengine"
local BS = require "bluecore.blueself"
local BN = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local Active = BN:extend();

function Active:new(...)
	Active.super.new(self,...);
end

function Active:_RecursiveNode(top, active)
	local childNode = top:GetChildrens();
	for i=1, #childNode do
		local node = childNode[i];
		node.Active = active;
		self:_RecursiveNode(node, active);
	end
end

function Active:_OnUpdate(args)
	local root   = args[1];
	local enable = args[2];
	local mySelf = args[3];
	local subs   = args[4];
	if mySelf then
		root.Active = enable
	end
	if subs then
		self:_RecursiveNode(root, enable);
	end
end

Active:RegisterInput(1, AE.Node:RTTI(), "target", "root node", BS());
Active:RegisterInput(2, Types.BoolType, "active", "active", true);
Active:RegisterInput(3, Types.BoolType, "self", "include self?" ,true);
Active:RegisterInput(4, Types.BoolType, "subs", "include sub-nodes?" ,true);

Active:RegisterExecInput (1, "exec", "exec");
Active:RegisterExecOutput(1, "exec", "exec");

Active:SetFunctionName("Actives");

return Active;