local mathfunction = require "mathfunction"
local BU = require "bluecore.blueutility"
local BlueNode = require "bluecore.bluenode"

local Types = require "venuscore.rtti.types"

local BreakFace106 = BlueNode:extend();

---- 游戏运行模式
function BreakFace106:new(...)
  BreakFace106.super.new(self, ...)
end

function BreakFace106:_OnUpdate(args)
  local face106 = args[1];
  if face106 == nil then
    return mathfunction.vector2(0,0), mathfunction.vector2(0,0), {}, mathfunction.vector3(0,0,0) ,{}
  else
    return  face106.position ~= nil and face106.position or mathfunction.vector2(0,0),
            face106.size ~= nil and face106.size or mathfunction.vector2(0,0),
            face106.landmark ~= nil and face106.landmark or {},
            face106.euler ~= nil and face106.euler or mathfunction.vector3(0,0,0),
            face106.visibility ~= nil and face106.visibility or {}
  end
end


---- 编辑器模式
BreakFace106:RegisterInput(1, Types.Face106Type, "Face106", "人脸106点信息", nil);
BreakFace106:RegisterOutput(1, mathfunction.vector2:RTTI(), "position", "人脸位置(left-top)");
BreakFace106:RegisterOutput(2, mathfunction.vector2:RTTI(), "size", "人脸框大小");
BreakFace106:RegisterOutput(3, BU:GetArrayRtti(mathfunction.vector2:RTTI()), "landmark", "人脸106关键点(数组)");
BreakFace106:RegisterOutput(4, mathfunction.vector3:RTTI(), "euler", "欧拉角");
BreakFace106:RegisterOutput(5, BU:GetArrayRtti(Types.BoolType), "visibility", "是否可见(数组)");

BreakFace106:SetFunctionName("BreakFace106");


return BreakFace106 ;

