local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetPostEffectValue = require "bluecore.base.get_posteffect_value"
local GetPostEffectScalar = GetPostEffectValue:extend();


---- 游戏运行模式
function GetPostEffectScalar:new(...)
  GetPostEffectScalar.super.new(self, ...)
end




function GetPostEffectScalar:_IsRightType(value)
  --local vec1 = type(value) == "userdata" and value:RTTI() == mathfunction.vector1():RTTI();
  local scalar = type(value) == "number";
  return scalar;
end



GetPostEffectScalar:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
GetPostEffectScalar:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 

GetPostEffectScalar:RegisterOutput(1, Types.FloatType, "ParaValue", "参数值");




GetPostEffectScalar:SetFunctionName("GetPostEffectScalar");


return GetPostEffectScalar ;

