require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

local brighteyes = {}

brighteyes.renderObject = nil;
brighteyes.queue = 100;
brighteyes.eyesmask = nil;
brighteyes.strengh = 0.5;
brighteyes.brightscale = 8;

brighteyes.EyeGuassXRenderObj = 0;
brighteyes.EyeGuassYRenderObj = 0;
brighteyes.RoGuassXRenderObj = 0;
brighteyes.RoGuassYRenderObj = 0;
brighteyes.BlendRenderObj = 0;

brighteyes.EyeGuassXMaterial = 0;
brighteyes.EyeGuassYMaterial = 0;
brighteyes.RoGuassXMaterial = 0;
brighteyes.RoGuassYMaterial = 0;
brighteyes.BlendMaterial = 0;


function brighteyes:Initialize(host, size)
  self.Stepsize1 = mathfunction.vector2(5, 5);
  self.Stepsize2 = mathfunction.vector2(5, 5);
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
  
  self.TEXTURE_EYEMASK = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_EYEMASK");
  self.TEXTURE_ORIGIN = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_ORIGIN");
  self.UNIFORM_STRENGTH = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_STRENGTH");
  self.UNIFORM_BRIGHTSCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_BRIGHTSCALE");
  
    
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  self.EyeGuassXRenderObj = host:CreateRenderObject();
  self.EyeGuassXMaterial = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
  self.EyeGuassXMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0) );
  
  self.EyeGuassYRenderObj = host:CreateRenderObject();
  self.EyeGuassYMaterial = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
  self.EyeGuassYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y()) );
  
  self.RoGuassXRenderObj = host:CreateRenderObject();
  self.RoGuassXMaterial = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
  self.RoGuassXMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), 0) );
  
  self.RoGuassYRenderObj = host:CreateRenderObject();
  self.RoGuassYMaterial = host:CreateMaterial( "comm:documents/material/gaussianblur.material" );
  self.RoGuassYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep2:y()) );
  
  self.BlendRenderObj = host:CreateRenderObject();
  self.BlendMaterial = host:CreateMaterial( "comm:documents/material/brighteyeblend.material" );
  self.BlendMaterial:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );
  self.BlendMaterial:SetParameter( self.UNIFORM_BRIGHTSCALE, mathfunction.vector1(self.brightscale) );
  
  self.blurXRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  self.blurYRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );
  self.blurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_C, size );
  return self.queue;
end

function brighteyes:Resizeview(size)
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  self.Stepsize2 = mathfunction.vector2(2, 2);
  self.size = size;
  self.EyeGuassXMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0 ) );
  self.EyeGuassYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y() ) );
  self.RoGuassXMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), 0 ) );
  self.RoGuassYMaterial:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep2:y() ) );
end

function brighteyes:Process(context, Original, Scene, Output)
  
  self:_UpdateParameters();
  local origintexture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  
  --self.blurXRT:PushRenderTarget();
	--self.blurXRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.blurXRT, apolloengine.RenderTargetEntity.CF_COLOR);
	self.EyeGuassXMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.eyesmask);
	--self.EyeGuassX:Draw(pipeline);
  context:Draw(self.EyeGuassXRenderObj, self.EyeGuassXMaterial);
  context:EndRenderPass();
  
  --self.blurYRT:PushRenderTarget();
  --self.blurYRT:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  context:BeginRenderPass(self.blurYRT, apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.EyeGuassYMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.blurXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  --self.EyeGuassY:Draw(pipeline);
  context:Draw(self.EyeGuassYRenderObj, self.EyeGuassYMaterial);
  context:EndRenderPass();
  local eyemask = self.blurYRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 );
  
  --self.blurXRT:PushRenderTarget();
	--self.blurXRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.blurXRT, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassXMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		origintexture);
	--self.RoGuassX:Draw(pipeline);
  context:Draw(self.RoGuassXRenderObj, self.RoGuassXMaterial);
  context:EndRenderPass();

  
  --self.blurRT:PushRenderTarget();
	--self.blurRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.blurRT, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassYMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.blurXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
	--self.RoGuassY:Draw(pipeline);
  context:Draw(self.RoGuassYRenderObj, self.RoGuassYMaterial);
  context:EndRenderPass();
  
  self.BlendMaterial:SetParameter(self.TEXTURE_ORIGIN,origintexture);
  self.BlendMaterial:SetParameter(self.TEXTURE_EYEMASK,eyemask);
  --Output:PushRenderTarget();
  --Output:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.BlendMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.blurRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  --self.Blend:Draw(pipeline);
  context:Draw(self.BlendRenderObj, self.BlendMaterial);
  context:EndRenderPass();

  
end

function brighteyes:_UpdateParameters()
  self.BlendMaterial:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );
end

return brighteyes;