local mathfunction = require "mathfunction"


local function stringsplit(inputstr, sep, cover)
  cover = cover or function(str) return str end;
  if sep == nil then
    sep = "%s"
  end
  local t={} ; i=1
  for str in string.gmatch(inputstr, "([^"..sep.."]+)") do
    t[i] = cover(str)
    i = i + 1
  end
  return t
end



function string.tovector(str)  
  local data = stringsplit(str, ",", tonumber);
  if #data == 1 then
    return mathfunction.vector1(data[1]);
  elseif #data == 2 then
    return mathfunction.vector2(data[1],data[2]);
  elseif #data == 3 then
    return mathfunction.vector3(data[1],data[2],data[3]);
  elseif #data == 4 then
    return mathfunction.vector4(data[1],data[2],data[3],data[4]);
  end
  return nil;
end
