#SHADER_DEFINE ClassifyVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
        { UNIFORM_HALF_SIZE,         HIGH,    VEC2,        "in_half_size"},

    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
        { ATTRIBUTE_COLOR0,          LOW,     VEC3,        "out_Color"},
    }

#SHADER_CODE

    float color = in_Position.z ;

    vec3 output_color ;

    output_color.r = step(0.5, fract(color/2.0)) ;

    color = floor(color/2.0);

    output_color.g = step(0.5, fract(color/2.0)) ;

    color = floor(color/2.0);

    output_color.b = step(0.5, fract(color/2.0)) ;

    vec3 out_Color = output_color;

    gl_Position = vec4((in_Position.xy - in_half_size)/in_half_size, 0.0, 1.0);

    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE ClassifyFragment

	FUNCTION_INPUT =
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_TexCoordinate" },
		{ ATTRIBUTE_COLOR0,     LOW,    VEC3,      "in_color"},
	}

#SHADER_CODE
    vec4 color = texture2D( in_DiffuseTexture, in_TexCoordinate );

    float alpha = 1.0 - ( color.r + color.g + color.b ) / 3.0 ;

    gl_FragColor = vec4( in_color , alpha) ;

#END_CODE
#END_DEFINE


#SHADER_DEFINE ClassifyVertex2

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { UNIFORM_HALF_SIZE,         HIGH,    VEC2,        "in_half_size"},
    }

    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COLOR0,          LOW,     VEC3,        "out_Color"},
    }


#SHADER_CODE

    float color = in_Position.z ;

    vec3 output_color ;

    output_color.r = step(0.5, fract(color/2.0)) ;

    color = floor(color/2.0);

    output_color.g = step(0.5, fract(color/2.0)) ;

    color = floor(color/2.0);

    output_color.b = step(0.5, fract(color/2.0)) ;

    vec3 out_Color = output_color;


    vec2 position = (in_Position.xy - in_half_size)/in_half_size ;
    gl_Position = vec4(position.x, -position.y, 0.0, 1.0);

#END_CODE
#END_DEFINE


#SHADER_DEFINE ClassifyFragment2

	FUNCTION_INPUT =
	{
	     { ATTRIBUTE_COLOR0,          LOW,     VEC3,        "in_Color"},
	}

#SHADER_CODE
    gl_FragColor = vec4(in_Color, 1.0);
#END_CODE
#END_DEFINE

