

#DEFPARAMS

#END

#DEFTAG
ShaderName = "Outline"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 TARGETSIZE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 size= TARGETSIZE;
    float2 uv = i.uv;
    float2 d = 1.0 / size;

    float4 u = ( -1.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2(-d.x, -d.y)) + -2.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2(-d.x, 0.0)) + -1.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2(-d.x, d.y)) + +1.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2( d.x, -d.y)) + +2.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2( d.x, 0.0)) + +1.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2( d.x, d.y)) ) ;
    float4 v = ( -1.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2(-d.x, -d.y)) + -2.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2( 0.0, -d.y)) + -1.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2( d.x, -d.y)) + +1.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2(-d.x, d.y)) + +2.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2( 0.0, d.y)) + +1.0 * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, 
		uv + float2( d.x, d.y)) ) ;

    mainColor = (1.0*d.y > 1.0)? float4((dot(u.xyz, u.xyz)), ( dot(v.xyz, v.xyz)), 0.5*(1.0+dot(u.xyz, v.xyz)), 1.0): float4((dot(u.xyz, u.xyz)), (dot(v.xyz, v.xyz)), 0.5*(1.0+dot(u.xyz, v.xyz)), 1.0);
}
ENDCG
#END
