

#DEFPARAMS
_MaskTex = { "Mask Texture", TEXTURE2D, "white" },
_CutOff = { "CutOff", FLOAT, "0.2" },
#END

#DEFTAG
ShaderName = "depthmaskonly" 
RenderQueue = "Opaque-1"
#END

#DEFPASS Always
COLOR_MASK = MPC_COLOR_NONE
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_ALWAYS } 
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM      
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{ 
	float4 vertex : SV_POSITION;
    float2 uv0 : TEXCOORD0;
};

Texture2D _MaskTex;
SamplerState _MaskTexSampler;
float _CutOff;

v2f vert(appdata v)
{  
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv0 = v.uv;
	o.vertex.z = 0.0;
	return o; 
}
   
void frag(in v2f i, out float4 outColor : SV_Target0)
{    
    float2 uv = i.uv0;

    float4 maskcolor =  _MaskTex.Sample(_MaskTexSampler,uv);
   
    if (maskcolor.a<_CutOff) 
    {
    		discard;
    }
    	

    outColor = float4(1.0,1.0,1.0,1.0);
}
ENDCG
#END
